/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.JavaCallable;
import org.jruby.runtime.ThreadContext;

public class JavaConstructor
extends JavaCallable {
    private final Constructor<?> constructor;

    public final Constructor getValue() {
        return this.constructor;
    }

    JavaConstructor(Constructor<?> constructor2) {
        super(constructor2.getParameterTypes());
        this.constructor = constructor2;
    }

    @Deprecated(since="9.4.0.0")
    public static JavaConstructor create(Ruby runtime2, Constructor<?> constructor2) {
        return new JavaConstructor(constructor2);
    }

    public static JavaConstructor wrap(Constructor<?> constructor2) {
        return new JavaConstructor(constructor2);
    }

    public static JavaConstructor getMatchingConstructor(Ruby runtime2, Class<?> javaClass, Class<?>[] argumentTypes) {
        Constructor c = ClassUtils.getMatchingConstructor(javaClass, argumentTypes);
        if (c == null) {
            return null;
        }
        return JavaConstructor.wrap(c);
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof JavaConstructor && this.constructor.equals(((JavaConstructor)other).constructor);
    }

    @Override
    public final int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public final Class<?>[] getExceptionTypes() {
        return this.constructor.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.constructor.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public final boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public final int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }

    public Class<?> getDeclaringClass() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public AccessibleObject accessibleObject() {
        return this.constructor;
    }

    public Object newInstanceDirect(ThreadContext context, Object ... arguments) {
        this.checkArity(context, arguments.length);
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context) {
        this.checkArity(context, 0);
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0) {
        this.checkArity(context, 1);
        try {
            return this.constructor.newInstance(arg0);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1) {
        this.checkArity(context, 2);
        try {
            return this.constructor.newInstance(arg0, arg1);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1, Object arg2) {
        this.checkArity(context, 3);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public Object newInstanceDirect(ThreadContext context, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(context, 4);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2, arg3);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, this.constructor, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, this.constructor);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }
}

