/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class PlatformEventType
extends Type {
    private final boolean isJVM;
    private final boolean isJDK;
    private final boolean isMethodSampling;
    private final List<SettingDescriptor> settings = new ArrayList<SettingDescriptor>(5);
    private final boolean dynamicSettings;
    private final int stackTraceOffset;
    private boolean enabled = false;
    private boolean stackTraceEnabled = true;
    private long thresholdTicks = 0L;
    private long period = 0L;
    private boolean hasHook;
    private boolean beginChunk;
    private boolean endChunk;
    private boolean hasStackTrace = true;
    private boolean hasDuration = true;
    private boolean hasPeriod = true;
    private boolean hasCutoff = false;
    private boolean isInstrumented;
    private boolean markForInstrumentation;
    private boolean registered = true;
    private boolean commitable = this.enabled && this.registered;

    PlatformEventType(String string, long l, boolean bl, boolean bl2) {
        super(string, Type.SUPER_TYPE_EVENT, l);
        this.dynamicSettings = bl2;
        this.isJVM = Type.isDefinedByJVM(l);
        this.isMethodSampling = string.equals("jdk.ExecutionSample") || string.equals("jdk.NativeMethodSample");
        this.isJDK = bl;
        this.stackTraceOffset = PlatformEventType.stackTraceOffset(string, bl);
    }

    private static int stackTraceOffset(String string, boolean bl) {
        if (bl) {
            if (string.equals("jdk.JavaExceptionThrow")) {
                return 5;
            }
            if (string.equals("jdk.JavaErrorThrow")) {
                return 5;
            }
        }
        return 4;
    }

    public void add(SettingDescriptor settingDescriptor) {
        Objects.requireNonNull(settingDescriptor);
        this.settings.add(settingDescriptor);
    }

    public List<SettingDescriptor> getSettings() {
        if (this.dynamicSettings) {
            ArrayList<SettingDescriptor> arrayList = new ArrayList<SettingDescriptor>(this.settings.size());
            for (SettingDescriptor settingDescriptor : this.settings) {
                if (!Utils.isSettingVisible(settingDescriptor.getTypeId(), this.hasHook)) continue;
                arrayList.add(settingDescriptor);
            }
            return arrayList;
        }
        return this.settings;
    }

    public List<SettingDescriptor> getAllSettings() {
        return this.settings;
    }

    public void setHasStackTrace(boolean bl) {
        this.hasStackTrace = bl;
    }

    public void setHasDuration(boolean bl) {
        this.hasDuration = bl;
    }

    public void setHasCutoff(boolean bl) {
        this.hasCutoff = bl;
    }

    public void setCutoff(long l) {
        if (this.isJVM) {
            long l2 = Utils.nanosToTicks(l);
            JVM.getJVM().setCutoff(this.getId(), l2);
        }
    }

    public void setHasPeriod(boolean bl) {
        this.hasPeriod = bl;
    }

    public boolean hasStackTrace() {
        return this.hasStackTrace;
    }

    public boolean hasDuration() {
        return this.hasDuration;
    }

    public boolean hasPeriod() {
        return this.hasPeriod;
    }

    public boolean hasCutoff() {
        return this.hasCutoff;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isJVM() {
        return this.isJVM;
    }

    public boolean isJDK() {
        return this.isJDK;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.updateCommitable();
        if (this.isJVM) {
            if (this.isMethodSampling) {
                long l = bl ? this.period : 0L;
                JVM.getJVM().setMethodSamplingInterval(this.getId(), l);
            } else {
                JVM.getJVM().setEnabled(this.getId(), bl);
            }
        }
    }

    public void setPeriod(long l, boolean bl, boolean bl2) {
        if (this.isMethodSampling) {
            long l2 = this.enabled ? l : 0L;
            JVM.getJVM().setMethodSamplingInterval(this.getId(), l2);
        }
        this.beginChunk = bl;
        this.endChunk = bl2;
        this.period = l;
    }

    public void setStackTraceEnabled(boolean bl) {
        this.stackTraceEnabled = bl;
        if (this.isJVM) {
            JVM.getJVM().setStackTraceEnabled(this.getId(), bl);
        }
    }

    public void setThreshold(long l) {
        this.thresholdTicks = Utils.nanosToTicks(l);
        if (this.isJVM) {
            JVM.getJVM().setThreshold(this.getId(), this.thresholdTicks);
        }
    }

    public boolean isEveryChunk() {
        return this.period == 0L;
    }

    public boolean getStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public long getThresholdTicks() {
        return this.thresholdTicks;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean hasEventHook() {
        return this.hasHook;
    }

    public void setEventHook(boolean bl) {
        this.hasHook = bl;
    }

    public boolean isBeginChunk() {
        return this.beginChunk;
    }

    public boolean isEndChunk() {
        return this.endChunk;
    }

    public boolean isInstrumented() {
        return this.isInstrumented;
    }

    public void setInstrumented() {
        this.isInstrumented = true;
    }

    public void markForInstrumentation(boolean bl) {
        this.markForInstrumentation = bl;
    }

    public boolean isMarkedForInstrumentation() {
        return this.markForInstrumentation;
    }

    public boolean setRegistered(boolean bl) {
        if (this.registered != bl) {
            LogTag logTag;
            this.registered = bl;
            this.updateCommitable();
            LogTag logTag2 = logTag = this.isJVM() || this.isJDK() ? LogTag.JFR_SYSTEM_EVENT : LogTag.JFR_EVENT;
            if (bl) {
                Logger.log(logTag, LogLevel.INFO, "Registered " + this.getLogName());
            } else {
                Logger.log(logTag, LogLevel.INFO, "Unregistered " + this.getLogName());
            }
            if (!bl) {
                MetadataRepository.getInstance().setUnregistered();
            }
            return true;
        }
        return false;
    }

    private void updateCommitable() {
        this.commitable = this.enabled && this.registered;
    }

    public final boolean isRegistered() {
        return this.registered;
    }

    public boolean isCommitable() {
        return this.commitable;
    }

    public int getStackTraceOffset() {
        return this.stackTraceOffset;
    }
}

