/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;

public class DefaultNodeValidator
implements NodeValidator {
    private final InternalProblems problemsService;

    public DefaultNodeValidator(InternalProblems problemsService) {
        this.problemsService = problemsService;
    }

    @Override
    public boolean hasValidationProblems(LocalTaskNode node) {
        WorkValidationContext validationContext = this.validateNode(node);
        List problems = validationContext.getProblems();
        this.logWarnings(problems);
        this.reportErrors(problems, node.getTask(), validationContext);
        return !problems.isEmpty();
    }

    private WorkValidationContext validateNode(LocalTaskNode node) {
        WorkValidationContext validationContext = node.getValidationContext();
        Class taskType = GeneratedSubclasses.unpackType((Object)node.getTask());
        TypeValidationContext typeValidationContext = validationContext.forType(taskType, false);
        node.getTaskProperties().validateType(typeValidationContext);
        return validationContext;
    }

    private void logWarnings(List<? extends InternalProblem> problems) {
        problems.stream().filter(DefaultNodeValidator::isWarning).forEach(problem -> {
            String warning = TypeValidationProblemRenderer.convertToSingleLine((String)TypeValidationProblemRenderer.renderMinimalInformationAbout((InternalProblem)problem, (boolean)false, (boolean)false));
            DeprecationMessageBuilder.withDocumentation((InternalProblem)problem, (DeprecationMessageBuilder.WithDeprecationTimeline)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBecomeAnErrorInGradle10()).nagUser();
        });
    }

    private void reportErrors(List<? extends InternalProblem> problems, TaskInternal task, WorkValidationContext validationContext) {
        for (InternalProblem internalProblem : problems) {
            this.problemsService.getInternalReporter().report((Problem)internalProblem);
        }
        Set<String> uniqueErrors = DefaultNodeValidator.getUniqueErrors(problems);
        if (!uniqueErrors.isEmpty()) {
            throw WorkValidationException.forProblems(uniqueErrors).withSummaryForContext(task.toString(), validationContext).get();
        }
    }

    private static Set<String> getUniqueErrors(List<? extends InternalProblem> problems) {
        return (Set)problems.stream().filter(problem -> !DefaultNodeValidator.isWarning(problem)).map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isWarning(InternalProblem problem) {
        return problem.getDefinition().getSeverity().equals((Object)Severity.WARNING);
    }
}

