/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.freeplane.view.swing.map.ZoomableLabel;

class ContentPaneLayout
implements LayoutManager {
    ContentPaneLayout() {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int componentCount = parent.getComponentCount();
        int width = parent.getWidth();
        int y = 0;
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            if (component.isVisible()) {
                component.validate();
                Dimension preferredCompSize = width == 0 ? new Dimension() : component.getPreferredSize();
                if (component instanceof ZoomableLabel) {
                    component.setBounds(0, y, width, preferredCompSize.height);
                } else if (width > preferredCompSize.width) {
                    int x = (int)(component.getAlignmentX() * (float)(width - preferredCompSize.width));
                    component.setBounds(x, y, preferredCompSize.width, preferredCompSize.height);
                } else {
                    component.setBounds(0, y, width, preferredCompSize.height);
                }
                y += preferredCompSize.height;
                continue;
            }
            component.setBounds(0, y, 0, 0);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension prefSize = new Dimension(0, 0);
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            if (!component.isVisible()) continue;
            component.validate();
            Dimension preferredCompSize = component.getPreferredSize();
            prefSize.height += preferredCompSize.height;
            prefSize.width = Math.max(prefSize.width, preferredCompSize.width);
        }
        return prefSize;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

