/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADSentenceSampleStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

@Internal
public class ADSentenceSampleStreamFactory
extends LanguageSampleStreamFactory<SentenceSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "ad", new ADSentenceSampleStreamFactory(Parameters.class));
    }

    protected ADSentenceSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        this.language = params.getLang();
        boolean includeTitle = params.getIncludeTitles();
        ObjectStream<String> lineStream = this.readData(args, Parameters.class);
        return new ADSentenceSampleStream(lineStream, includeTitle);
    }

    public static interface Parameters
    extends BasicFormatParams {
        @Override
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="includeTitles", description="if true will include sentences marked as headlines.")
        @ArgumentParser.OptionalParameter(defaultValue="false")
        public Boolean getIncludeTitles();
    }
}

