__all__ = [
    "__version__",
    "AbstractProvider",
    "AbstractResolver",
    "BaseReporter",
    "InconsistentCandidate",
    "Resolver",
    "RequirementsConflicted",
    "ResolutionError",
    "ResolutionImpossible",
    "ResolutionTooDeep",
]

__version__ = "1.1.0"


from .providers import AbstractProvider
from .reporters import BaseReporter
from .resolvers import (
    AbstractResolver,
    InconsistentCandidate,
    RequirementsConflicted,
    ResolutionError,
    ResolutionImpossible,
    ResolutionTooDeep,
    Resolver,
)
