How to write a gedit plugin
===========================

The [gedit-development-getting-started.md](gedit-development-getting-started.md)
documentation is a good start.

Programming language for a gedit plugin
---------------------------------------

The preferred language is the C language, that way the code can be easily moved
elsewhere (for example as re-usable code in a library that can be shared with
other text editors).

Rust and C++ should be possible too, but have not been tried yet for a gedit
plugin.

There was a plugin implemented in Vala (but has been removed), so that's
another possibility.

For gedit and gedit-plugins we prefer to deal with a single programming
language (C), that way we avoid the complexity of managing a multi-language
project.

For third-party plugins, you thus have the choice between C, Rust, C++ and
Vala.

### What about Python?

There were some plugins implemented in Python, but have been removed because
they no longer worked after an update.

So gedit plugins can no longer be implemented in Python.

API reference
-------------

Build gedit with `-D gtk_doc=true`, you can then browse the API reference in the
[Devhelp](https://wiki.gnome.org/Apps/Devhelp) application.

To know how to write a plugin, refer to the
[libpeas](https://wiki.gnome.org/Projects/Libpeas) documentation as well.

More documentation and tips
---------------------------

More documentation, for example a tutorial, would be useful. In the meantime,
the recommended thing to do is to see how core gedit plugins are implemented.

### Unofficial documentation and tutorials (may be outdated)

- [Writing plugins in Vala](https://wiki.gnome.org/Projects/Vala/Gedit3PluginSample) (maybe outdated)
