/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.transforms;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.initialization.ConventionInterfaceGenerator;
import org.gradle.internal.classpath.transforms.CommonTypes;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class ConventionInterceptors {
    static final Type PROJECT_TYPE = Type.getType(Project.class);
    static final Type CONVENTION_INTERCEPTORS_TYPE = Type.getType(ConventionInterceptors.class);
    static final String RETURN_OBJECT_FROM_PROJECT = Type.getMethodDescriptor((Type)CommonTypes.OBJECT_TYPE, (Type[])new Type[]{PROJECT_TYPE});
    static final String RETURN_CONVENTION = Type.getMethodDescriptor((Type)ConventionInterfaceGenerator.CONVENTION_TYPE, (Type[])new Type[0]);

    public static Object interceptProjectGetConventionMethod(Project project) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> aClass = Class.forName("org.gradle.api.plugins.internal.DefaultDecoratedConvention", true, Thread.currentThread().getContextClassLoader());
        return aClass.getConstructor(ExtensionContainer.class).newInstance(project.getExtensions());
    }

    public boolean visitMethodInsn(MethodVisitorScope mv, String className, int opcode, String owner, String name, String descriptor, boolean isInterface, Supplier<MethodNode> readMethodNode) {
        if (opcode != 182 && opcode != 185) {
            return false;
        }
        if (PROJECT_TYPE.getInternalName().equals(owner) && "getConvention".equals(name) && RETURN_CONVENTION.equals(descriptor)) {
            mv._INVOKESTATIC(CONVENTION_INTERCEPTORS_TYPE, "interceptProjectGetConventionMethod", RETURN_OBJECT_FROM_PROJECT);
            return true;
        }
        return false;
    }
}

