/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.net.URI;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class UriBasenameTask
extends Task {
    private URI file;
    private String property;
    private String suffix;

    public void setFile(URI file) {
        this.file = file;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute required", this.getLocation());
        }
        if (this.file == null) {
            throw new BuildException("file attribute required", this.getLocation());
        }
        String value = this.getName(this.file.getPath());
        if (this.suffix != null && value.endsWith(this.suffix)) {
            int pos = value.length() - this.suffix.length();
            if (pos > 0 && this.suffix.charAt(0) != '.' && value.charAt(pos - 1) == '.') {
                --pos;
            }
            value = value.substring(0, pos);
        } else if (this.suffix != null && this.suffix.equals(".*") && value.indexOf(46) != -1) {
            value = value.substring(0, value.indexOf(46));
        }
        this.getProject().setNewProperty(this.property, value);
    }

    private String getName(String path) {
        int i = path.lastIndexOf("/");
        if (i != -1) {
            return path.substring(i + 1);
        }
        return path;
    }
}

