/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AbstractPatternFunction;
import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.relaxng.pattern.NullNameClass;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.UnionNameClassNormalizer;
import com.thaiopensource.util.VoidValue;

abstract class PossibleNamesFunction
extends AbstractPatternFunction<VoidValue> {
    private final UnionNameClassNormalizer normalizer = new UnionNameClassNormalizer();

    PossibleNamesFunction() {
    }

    NormalizedNameClass applyTo(Pattern pattern) {
        this.normalizer.setNameClass(new NullNameClass());
        pattern.apply(this);
        return this.normalizer.normalize();
    }

    void add(NameClass nameClass) {
        this.normalizer.add(nameClass);
    }

    @Override
    public VoidValue caseAfter(AfterPattern afterPattern) {
        return afterPattern.getOperand1().apply(this);
    }

    public VoidValue caseBinary(BinaryPattern binaryPattern) {
        binaryPattern.getOperand1().apply(this);
        binaryPattern.getOperand2().apply(this);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue caseChoice(ChoicePattern choicePattern) {
        return this.caseBinary(choicePattern);
    }

    @Override
    public VoidValue caseInterleave(InterleavePattern interleavePattern) {
        return this.caseBinary(interleavePattern);
    }

    @Override
    public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return oneOrMorePattern.getOperand().apply(this);
    }

    @Override
    public VoidValue caseOther(Pattern pattern) {
        return VoidValue.VOID;
    }
}

