/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import jlibs.core.lang.ImpossibleException;

public abstract class PumpedInputStream
extends PipedInputStream
implements Runnable {
    private PipedOutputStream out = new PipedOutputStream();
    private IOException exception;

    public PumpedInputStream() {
        try {
            super.connect(this.out);
        }
        catch (IOException ex) {
            throw new ImpossibleException();
        }
    }

    private void setException(Exception ex) {
        this.exception = ex instanceof IOException ? (IOException)ex : new IOException(ex);
    }

    @Override
    public void run() {
        try {
            this.pump(this.out);
        }
        catch (Exception ex) {
            this.setException(ex);
        }
        finally {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                this.exception = ex;
            }
        }
    }

    public PumpedInputStream start() {
        new Thread(this).start();
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    protected abstract void pump(PipedOutputStream var1) throws Exception;
}

