import lsp from 'vscode-languageserver';
import type { LspClient } from '../lsp-client.js';
export declare enum LogLevel {
    Error = 0,
    Warning = 1,
    Info = 2,
    Log = 3
}
export declare namespace LogLevel {
    function fromString(value?: string): LogLevel;
    function toString(level: LogLevel): string;
}
declare type TraceLevel = 'Trace' | 'Info' | 'Error';
export interface Logger {
    error(...args: any[]): void;
    warn(...args: any[]): void;
    info(...args: any[]): void;
    log(...args: any[]): void;
    /**
     * Logs the arguments regardless of the verbosity level set for the logger.
     */
    logIgnoringVerbosity(level: LogLevel, ...args: any[]): void;
    /**
     * Logs the arguments regardless of the verbosity level in a trace-specific format.
     */
    trace(level: TraceLevel, message: string, data?: any): void;
}
export declare class LspClientLogger implements Logger {
    private client;
    private level;
    constructor(client: LspClient, level: lsp.MessageType);
    private sendMessage;
    private logLevelToLspMessageType;
    error(...args: any[]): void;
    warn(...args: any[]): void;
    info(...args: any[]): void;
    log(...args: any[]): void;
    logIgnoringVerbosity(level: LogLevel, ...args: any[]): void;
    trace(level: TraceLevel, message: string, data?: any): void;
}
export declare class ConsoleLogger implements Logger {
    private level;
    constructor(level?: LogLevel);
    private print;
    private toStrings;
    error(...args: any[]): void;
    warn(...args: any[]): void;
    info(...args: any[]): void;
    log(...args: any[]): void;
    logIgnoringVerbosity(level: LogLevel, ...args: any[]): void;
    trace(level: TraceLevel, message: string, data?: any): void;
}
export declare class PrefixingLogger implements Logger {
    private logger;
    private prefix;
    constructor(logger: Logger, prefix: string);
    error(...args: any[]): void;
    warn(...args: any[]): void;
    info(...args: any[]): void;
    log(...args: any[]): void;
    logIgnoringVerbosity(level: LogLevel, ...args: any[]): void;
    trace(level: TraceLevel, message: string, data?: any): void;
}
export {};
//# sourceMappingURL=logger.d.ts.map