import * as lsp from 'vscode-languageserver';
export interface WithProgressOptions {
    message: string;
    reporter: lsp.WorkDoneProgressReporter;
}
export interface LspClient {
    createProgressReporter(token?: lsp.CancellationToken, workDoneProgress?: lsp.WorkDoneProgressReporter): Promise<lsp.WorkDoneProgressReporter>;
    withProgress<R>(options: WithProgressOptions, task: (progress: lsp.WorkDoneProgressReporter) => Promise<R>): Promise<R>;
    publishDiagnostics(args: lsp.PublishDiagnosticsParams): void;
    showErrorMessage(message: string): void;
    logMessage(args: lsp.LogMessageParams): void;
    applyWorkspaceEdit(args: lsp.ApplyWorkspaceEditParams): Promise<lsp.ApplyWorkspaceEditResult>;
    rename(args: lsp.TextDocumentPositionParams): Promise<any>;
}
export declare class LspClientImpl implements LspClient {
    protected connection: lsp.Connection;
    constructor(connection: lsp.Connection);
    createProgressReporter(_?: lsp.CancellationToken, workDoneProgress?: lsp.WorkDoneProgressReporter): Promise<lsp.WorkDoneProgressReporter>;
    withProgress<R = unknown>(options: WithProgressOptions, task: (progress: lsp.WorkDoneProgressReporter) => Promise<R>): Promise<R>;
    publishDiagnostics(params: lsp.PublishDiagnosticsParams): void;
    showErrorMessage(message: string): void;
    logMessage(args: lsp.LogMessageParams): void;
    applyWorkspaceEdit(params: lsp.ApplyWorkspaceEditParams): Promise<lsp.ApplyWorkspaceEditResult>;
    rename(args: lsp.TextDocumentPositionParams): Promise<any>;
}
//# sourceMappingURL=lsp-client.d.ts.map