/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableByteObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableByteObjectMap;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;

/**
 * ImmutableByteObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteObjectMapFactoryImpl implements ImmutableByteObjectMapFactory
{
    public <V> ImmutableByteObjectMap<V> empty()
    {
        return (ImmutableByteObjectMap<V>) ImmutableByteObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableByteObjectMap<V> of()
    {
        return this.empty();
    }

    public <V> ImmutableByteObjectMap<V> with()
    {
        return this.empty();
    }

    public <V> ImmutableByteObjectMap<V> of(byte key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableByteObjectMap<V> with(byte key, V value)
    {
        return new ImmutableByteObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableByteObjectMap<V> ofAll(ByteObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableByteObjectMap<V> withAll(ByteObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableByteObjectMap)
        {
            return (ImmutableByteObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final byte[] array = new byte[1];
            map.forEachKey(new ByteProcedure()
            {
                public void value(byte each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableByteObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableByteObjectHashMap<V>(map);
    }
}
