/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.junit.Assert;
import org.junit.Test;

public class FloatDeclarationTest {
    private FloatDeclaration fixture;

    @Test
    public void ctorTest() {
        int i = 1;
        while (i < 20) {
            this.fixture = new FloatDeclaration(i, 32 - i, ByteOrder.nativeOrder(), 0L);
            Assert.assertNotNull((Object)this.fixture);
            ++i;
        }
    }

    @Test
    public void getterTest() {
        this.fixture = new FloatDeclaration(8, 24, ByteOrder.nativeOrder(), 1L);
        Assert.assertEquals((long)this.fixture.getAlignment(), (long)1L);
        Assert.assertEquals((Object)this.fixture.getByteOrder(), (Object)ByteOrder.nativeOrder());
        Assert.assertEquals((long)this.fixture.getExponent(), (long)8L);
        Assert.assertEquals((long)this.fixture.getMantissa(), (long)24L);
    }

    @Test
    public void toStringTest() {
        this.fixture = new FloatDeclaration(8, 24, ByteOrder.nativeOrder(), 0L);
        Assert.assertTrue((boolean)this.fixture.toString().contains("float"));
    }

    @Test
    public void hashcodeTest() {
        FloatDeclaration floatDeclaration = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 0L);
        FloatDeclaration a = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 0L);
        FloatDeclaration b = new FloatDeclaration(8, 24, ByteOrder.LITTLE_ENDIAN, 0L);
        Assert.assertEquals((long)a.hashCode(), (long)floatDeclaration.hashCode());
        Assert.assertNotEquals((long)b.hashCode(), (long)floatDeclaration.hashCode());
        Assert.assertEquals((long)floatDeclaration.hashCode(), (long)floatDeclaration.hashCode());
    }

    @Test
    public void equalsTest() {
        FloatDeclaration a = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 0L);
        FloatDeclaration b = new FloatDeclaration(8, 24, ByteOrder.LITTLE_ENDIAN, 0L);
        FloatDeclaration c = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 8L);
        FloatDeclaration d = new FloatDeclaration(8, 8, ByteOrder.BIG_ENDIAN, 0L);
        FloatDeclaration e = new FloatDeclaration(24, 24, ByteOrder.BIG_ENDIAN, 0L);
        FloatDeclaration f = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 0L);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertNotEquals((Object)d, (Object)a);
        Assert.assertNotEquals((Object)e, (Object)a);
        Assert.assertNotEquals((Object)a, (Object)e);
        Assert.assertEquals((Object)a, (Object)f);
        Assert.assertEquals((Object)f, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
    }
}

