/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.AbstractSegmentStoreStatisticsDataProvider;
import org.junit.Assert;

public abstract class AbstractSegmentStoreStatisticsDataProviderTest {
    protected static void verifyEntries(List<@NonNull List<@NonNull String>> expectedLabels, @NonNull List<@NonNull StatisticsHolder> expectedEntries, List<@NonNull SegmentStoreStatisticsModel> entries, int startIndex, int nbEntries) {
        Assert.assertEquals((String)"Number of entries", (long)nbEntries, (long)entries.size());
        int i = 0;
        while (i < expectedLabels.size()) {
            int index = startIndex + i;
            SegmentStoreStatisticsModel entry = entries.get(index);
            Assert.assertEquals((String)("Entry (index " + index + ")"), expectedLabels.get(i), (Object)entry.getLabels());
            Assert.assertEquals((String)("name (index " + index + ")"), (Object)expectedEntries.get((int)i).fName, (Object)entry.getName());
            Assert.assertEquals((String)("id (index " + index + ")"), (long)expectedEntries.get((int)i).fId, (long)entry.getId());
            Assert.assertEquals((String)("parentId (index " + index + ")"), (long)expectedEntries.get((int)i).fParentId, (long)entry.getParentId());
            Assert.assertEquals((String)("min (index " + index + ")"), (long)expectedEntries.get((int)i).fMin, (long)entry.getMin());
            Assert.assertEquals((String)("max (index " + index + ")"), (long)expectedEntries.get((int)i).fMax, (long)entry.getMax());
            Assert.assertEquals((String)("Average (index " + index + ")"), (double)expectedEntries.get((int)i).fAverage, (double)entry.getMean(), (double)0.02);
            Assert.assertEquals((String)("StdDev (index " + index + ")"), (double)expectedEntries.get((int)i).fStdDev, (double)entry.getStdDev(), (double)0.02);
            Assert.assertEquals((String)("Count (index " + index + ")"), (long)expectedEntries.get((int)i).fNbElements, (long)entry.getNbElements());
            Assert.assertEquals((String)("Total (index " + index + ")"), (double)expectedEntries.get((int)i).fTotal, (double)entry.getTotal(), (double)0.02);
            Assert.assertEquals((String)("Min start (index " + index + ")"), (long)expectedEntries.get((int)i).fMinStart, (long)entry.getMinStart());
            Assert.assertEquals((String)("Min end (index " + index + ")"), (long)expectedEntries.get((int)i).fMinEnd, (long)entry.getMinEnd());
            Assert.assertEquals((String)("Max start (index " + index + ")"), (long)expectedEntries.get((int)i).fMaxStart, (long)entry.getMaxStart());
            Assert.assertEquals((String)("Max end (index " + index + ")"), (long)expectedEntries.get((int)i).fMaxEnd, (long)entry.getMaxEnd());
            ++i;
        }
    }

    protected static void verifyEntriesWithUserDefinedAspect(List<@NonNull List<@NonNull String>> expectedLabels, @NonNull List<@NonNull StatisticsHolderUserDefined> expectedEntriesUserDefined, List<@NonNull SegmentStoreStatisticsModel> entries, int startIndex, int nbEntries) {
        @NonNull List<@NonNull StatisticsHolder> expectedEntries = expectedEntriesUserDefined.stream().collect(Collectors.toList());
        AbstractSegmentStoreStatisticsDataProviderTest.verifyEntries(expectedLabels, expectedEntries, entries, startIndex, nbEntries);
        int i = 0;
        while (i < expectedLabels.size()) {
            String expectedUserDefinedValue = expectedEntriesUserDefined.get((int)i).fUserDefinedField;
            int index = startIndex + i;
            SegmentStoreStatisticsModel entry = entries.get(index);
            Assert.assertTrue((String)("User defined aspect not found (index " + index + ")"), (boolean)entry.getLabels().stream().anyMatch(s -> s.equals(expectedUserDefinedValue)));
            ++i;
        }
    }

    protected static void resetIds() {
        try {
            Field entryIdField = AbstractSegmentStoreStatisticsDataProvider.class.getDeclaredField("ENTRY_ID");
            entryIdField.setAccessible(true);
            Object entryIdObject = entryIdField.get(null);
            Class<?> entryIdClass = entryIdObject.getClass();
            Method setMethod = entryIdClass.getDeclaredMethod("set", Long.TYPE);
            setMethod.invoke(entryIdObject, 0L);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Assert.fail((String)("Error resetting entry ID: " + e.getMessage()));
        }
    }

    protected static class StatisticsHolder {
        String fName;
        long fId;
        long fParentId;
        long fMin;
        long fMax;
        long fNbElements;
        double fAverage;
        double fStdDev;
        double fTotal;
        long fMinStart;
        long fMinEnd;
        long fMaxStart;
        long fMaxEnd;

        public StatisticsHolder(String name, long id, long parentId, long min, long max, double average, double stdDev, long nbElements, double total, long minStart, long minEnd, long maxStart, long maxEnd) {
            this.fName = name;
            this.fId = id;
            this.fParentId = parentId;
            this.fMin = min;
            this.fMax = max;
            this.fNbElements = nbElements;
            this.fAverage = average;
            this.fStdDev = stdDev;
            this.fTotal = total;
            this.fMinStart = minStart;
            this.fMinEnd = minEnd;
            this.fMaxStart = maxStart;
            this.fMaxEnd = maxEnd;
        }
    }

    protected static class StatisticsHolderUserDefined
    extends StatisticsHolder {
        String fUserDefinedField;

        public StatisticsHolderUserDefined(String name, long id, long parentId, long min, long max, double average, double stdDev, long nbElements, double total, long minStart, long minEnd, long maxStart, long maxEnd, String userDefinedField) {
            super(name, id, parentId, min, max, average, stdDev, nbElements, total, minStart, minEnd, maxStart, maxEnd);
            this.fUserDefinedField = userDefinedField;
        }
    }
}

