/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfTreeContentProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfTreeContentProviderTest {
    private static final String fTestName = "TreeContentProviderTest";
    private final @NonNull String fTypeId1 = "Some type1";
    private final @NonNull String fTypeId2 = "Some type2";
    private final String fLabel0 = "label1";
    private final String fLabel1 = "label2";
    private final String[] fLabels = new String[]{"label1", "label2"};
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final ITmfTimestamp fTimestamp2 = TmfTimestamp.create((long)12350L, (int)2);
    private final TmfEventType fType1 = new TmfEventType("Some type1", TmfEventField.makeRoot((String[])this.fLabels));
    private final TmfEventType fType2 = new TmfEventType("Some type2", TmfEventField.makeRoot((String[])this.fLabels));
    private final ITmfEvent fEvent1;
    private final ITmfEvent fEvent2;
    private final TmfEventField fContent1 = new TmfEventField(":root:", (Object)"Some content", null);
    private final TmfEventField fContent2;
    private final TmfStatisticsTree fStatsData;
    private final TmfTreeContentProvider treeProvider;

    public TmfTreeContentProviderTest() {
        this.fEvent1 = new TmfEvent(null, -1L, this.fTimestamp1, (ITmfEventType)this.fType1, (ITmfEventField)this.fContent1);
        this.fContent2 = new TmfEventField(":root:", (Object)"Some other content", null);
        this.fEvent2 = new TmfEvent(null, -1L, this.fTimestamp2, (ITmfEventType)this.fType2, (ITmfEventField)this.fContent2);
        this.fStatsData = new TmfStatisticsTree();
        this.fStatsData.setTotal(fTestName, true, 2L);
        this.fStatsData.setTypeCount(fTestName, this.fEvent1.getName(), true, 1L);
        this.fStatsData.setTypeCount(fTestName, this.fEvent2.getName(), true, 1L);
        this.treeProvider = new TmfTreeContentProvider();
    }

    @Test
    public void testGetChildren() {
        Object[] objectArray = this.treeProvider.getChildren((Object)this.fStatsData.getOrCreateNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}));
        TmfStatisticsTreeNode[] childrenNode = Arrays.asList(objectArray).toArray(new TmfStatisticsTreeNode[0]);
        String[][] childrenExpected = new String[][]{{fTestName, Messages.TmfStatisticsData_EventTypes, this.fEvent1.getName()}, {fTestName, Messages.TmfStatisticsData_EventTypes, this.fEvent2.getName()}};
        Assert.assertEquals((String)"getChildren", (long)childrenExpected.length, (long)childrenNode.length);
        TmfStatisticsTreeNode[] tmfStatisticsTreeNodeArray = childrenNode;
        int n = childrenNode.length;
        int n2 = 0;
        while (n2 < n) {
            TmfStatisticsTreeNode childNode = tmfStatisticsTreeNodeArray[n2];
            if (!TmfTreeContentProviderTest.arrayOfArraysContains(childrenExpected, childNode.getPath())) {
                Assert.fail();
            }
            ++n2;
        }
    }

    private static boolean arrayOfArraysContains(String[][] arrayOfArrays, String[] array) {
        String[][] stringArray = arrayOfArrays;
        int n = arrayOfArrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] curArray = stringArray[n2];
            if (TmfTreeContentProviderTest.arraysEqual(curArray, array)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean arraysEqual(String[] array1, String[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!array1[i].equals(array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Test
    public void testGetParent() {
        TmfStatisticsTreeNode parent = (TmfStatisticsTreeNode)this.treeProvider.getParent((Object)this.fStatsData.getNode(new String[]{fTestName}));
        Assert.assertNotNull((String)"getParent", (Object)parent);
        Assert.assertTrue((String)"getParent", (boolean)parent.getPath().equals(this.fStatsData.getRootNode().getPath()));
    }

    @Test
    public void testHasChildren() {
        boolean hasChildren = this.treeProvider.hasChildren((Object)this.fStatsData.getRootNode());
        Assert.assertTrue((String)"hasChildren", (boolean)hasChildren);
        hasChildren = this.treeProvider.hasChildren((Object)this.fStatsData.getOrCreateNode(new String[]{fTestName}));
        Assert.assertTrue((String)"hasChildren", (boolean)hasChildren);
        hasChildren = this.treeProvider.hasChildren((Object)this.fStatsData.getOrCreateNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes}));
        Assert.assertTrue((String)"hasChildren", (boolean)hasChildren);
        hasChildren = this.treeProvider.hasChildren((Object)this.fStatsData.getOrCreateNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, this.fEvent1.getName()}));
        Assert.assertFalse((String)"hasChildren", (boolean)hasChildren);
    }

    @Test
    public void testGetElements() {
        Object[] objectElements = this.treeProvider.getElements((Object)this.fStatsData.getRootNode());
        TmfStatisticsTreeNode[] nodeElements = Arrays.asList(objectElements).toArray(new TmfStatisticsTreeNode[0]);
        Assert.assertEquals((String)"getElements", (long)1L, (long)nodeElements.length);
        Assert.assertTrue((String)"getElements", (boolean)nodeElements[0].getPath()[0].equals(fTestName));
    }
}

