/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.coff.Coff64;
import org.eclipse.cdt.utils.coff.PE64;
import org.eclipse.core.runtime.IPath;

public class PEBinaryObject64
extends BinaryObjectAdapter {
    BinaryObjectAdapter.BinaryObjectInfo info;
    IAddressFactory addressFactory;
    IBinaryParser.ISymbol[] symbols;
    AR.ARHeader header;

    public PEBinaryObject64(IBinaryParser parser, IPath path, AR.ARHeader header) {
        super(parser, path, 1);
    }

    public PEBinaryObject64(IBinaryParser parser, IPath p, int type) {
        super(parser, p, type);
    }

    @Override
    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    @Override
    public InputStream getContents() throws IOException {
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        return super.getContents();
    }

    @Override
    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadAll();
            }
            catch (IOException e) {
                this.symbols = NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    @Override
    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        if (this.hasChanged() || this.info == null) {
            try {
                this.loadInfo();
            }
            catch (IOException e) {
                this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
            }
        }
        return this.info;
    }

    public <T> T getAdapter(Class<T> adapter) {
        PE64 pe;
        if (adapter.equals(PE64.class)) {
            try {
                if (this.header != null) {
                    return (T)new PE64(this.getPath().toOSString(), this.header.getObjectDataOffset());
                }
                return (T)new PE64(this.getPath().toOSString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (adapter.equals(ISymbolReader.class) && (pe = this.getAdapter(PE64.class)) != null) {
            return (T)pe.getSymbolReader();
        }
        return (T)super.getAdapter(adapter);
    }

    protected PE64 getPE() throws IOException {
        if (this.header != null) {
            return new PE64(this.getPath().toOSString(), this.header.getObjectDataOffset());
        }
        return new PE64(this.getPath().toOSString());
    }

    protected void loadAll() throws IOException {
        PE64 pe = null;
        try {
            pe = this.getPE();
            this.loadInfo(pe);
            this.loadSymbols(pe);
        }
        finally {
            if (pe != null) {
                pe.dispose();
            }
        }
    }

    protected void loadInfo() throws IOException {
        PE64 pe = null;
        try {
            pe = this.getPE();
            this.loadInfo(pe);
        }
        finally {
            if (pe != null) {
                pe.dispose();
            }
        }
    }

    protected void loadInfo(PE64 pe) throws IOException {
        this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
        PE64.Attribute attribute = this.getPE().getAttribute();
        this.info.isLittleEndian = attribute.isLittleEndian();
        this.info.hasDebug = attribute.hasDebug();
        this.info.cpu = attribute.getCPU();
    }

    protected void loadSymbols(PE64 pe) throws IOException {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        this.loadSymbols(pe, list);
        this.symbols = list.toArray(NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void loadSymbols(PE64 pe, List<Symbol> list) throws IOException {
        Coff64.Symbol[] peSyms = pe.getSymbols();
        byte[] table = pe.getStringTable();
        this.addSymbols(peSyms, table, list);
    }

    protected void addSymbols(Coff64.Symbol[] peSyms, byte[] table, List<Symbol> list) {
        Coff64.Symbol[] symbolArray = peSyms;
        int n = peSyms.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Coff64.Symbol peSym = symbolArray[n2];
            if ((peSym.isFunction() || peSym.isPointer() || peSym.isArray()) && (name = peSym.getName(table)) != null && name.trim().length() != 0 && Character.isJavaIdentifierStart(name.charAt(0))) {
                int type = peSym.isFunction() ? 1 : 2;
                list.add(new Symbol(this, name, type, new Addr32(peSym.n_value), peSym.getSize()));
            }
            ++n2;
        }
    }

    @Override
    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            this.addressFactory = new Addr32Factory();
        }
        return this.addressFactory;
    }
}

