/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfilesReader;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;

public class ExtractRemoteProfilesOperation
extends AbstractTracePackageOperation {
    public ExtractRemoteProfilesOperation(String fileName) {
        super(fileName);
    }

    public void run(IProgressMonitor progressMonitor) {
        TracePackageElement[] elements = null;
        try {
            FileInputStream inputStream;
            progressMonitor.worked(1);
            File file = new File(this.getFileName());
            progressMonitor.worked(1);
            if (!file.exists()) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", "Invalid format"));
                return;
            }
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                inputStream = new FileInputStream(file);
                try {
                    RemoteImportProfilesReader.validate(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                inputStream = new FileInputStream(file);
                try {
                    elements = RemoteImportProfilesReader.loadElementsFromProfiles(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            progressMonitor.worked(1);
            this.setResultElements(elements);
            this.setStatus(Status.OK_STATUS);
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", "Error reading profiles", (Throwable)e));
        }
    }
}

