/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.Optional;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DRepresentationDescriptorToDRepresentationLinkManager {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorToDRepresentationLinkManager(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public void setRepresentation(DRepresentation representation) {
        if (representation != null) {
            String iD = representation.getUid();
            Optional.ofNullable(representation.eResource()).map(resource -> resource.getURI().appendFragment(iD)).ifPresent(uri -> this.repDescriptor.setRepPath(new ResourceDescriptor((URI)uri)));
        } else {
            this.repDescriptor.setRepPath(null);
        }
    }

    public Optional<DRepresentation> getRepresentation(boolean loadOnDemand) {
        Optional<DRepresentation> representation = this.getRepresentationInternal(false);
        if (loadOnDemand && !representation.isPresent()) {
            representation = this.getRepresentationInternal(true);
            representation.ifPresent(rep -> Optional.ofNullable(new EObjectQuery(this.repDescriptor).getSession()).map(Session::getSemanticCrossReferencer).ifPresent(crossRef -> {
                crossRef.setTarget((Notifier)this.repDescriptor);
                rep.eAdapters().add(crossRef);
            }));
        }
        return representation;
    }

    private Optional<DRepresentation> getRepresentationInternal(boolean loadOnDemand) {
        ResourceDescriptor resourceDescriptor = this.repDescriptor.getRepPath();
        Resource resource = this.repDescriptor.eResource();
        Optional<URI> uri = Optional.ofNullable(resourceDescriptor).map(desc -> desc.getResourceURI());
        if (uri.isPresent()) {
            Optional<Resource> representationResource = Optional.ofNullable(resource).map(rsr -> rsr.getResourceSet()).map(resourceSet -> resourceSet.getResource(((URI)uri.get()).trimFragment(), loadOnDemand));
            String repId = uri.get().fragment();
            if (representationResource.isPresent() && repId != null) {
                return representationResource.get().getContents().stream().filter(DRepresentation.class::isInstance).map(DRepresentation.class::cast).filter(dRepresentation -> repId.equals(dRepresentation.getUid())).findFirst();
            }
        }
        return Optional.empty();
    }
}

