/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.grm.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.polarsys.time4sys.library.LibraryFactory;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.SchedPolicyKind;
import org.polarsys.time4sys.marte.grm.Scheduler;
import org.polarsys.time4sys.marte.grm.SchedulingPolicy;
import org.polarsys.time4sys.marte.grm.provider.ResourceBrokerItemProvider;

public class SchedulerItemProvider
extends ResourceBrokerItemProvider {
    public SchedulerItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addHostPropertyDescriptor(object);
            this.addProcessingUnitsPropertyDescriptor(object);
            this.addSchedulableResourcePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addHostPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Scheduler_host_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Scheduler_host_feature", "_UI_Scheduler_type"), (EStructuralFeature)GrmPackage.Literals.SCHEDULER__HOST, true, false, true, null, null, null));
    }

    protected void addProcessingUnitsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Scheduler_processingUnits_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Scheduler_processingUnits_feature", "_UI_Scheduler_type"), (EStructuralFeature)GrmPackage.Literals.SCHEDULER__PROCESSING_UNITS, true, false, true, null, null, null));
    }

    protected void addSchedulableResourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Scheduler_schedulableResource_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Scheduler_schedulableResource_feature", "_UI_Scheduler_type"), (EStructuralFeature)GrmPackage.Literals.SCHEDULER__SCHEDULABLE_RESOURCE, true, false, true, null, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(GrmPackage.Literals.SCHEDULER__POLICY);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Scheduler"));
    }

    @Override
    public String getText(Object object) {
        String label = ((Scheduler)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_Scheduler_type") : String.valueOf(this.getString("_UI_Scheduler_type")) + " " + label;
    }

    protected String getTypeText(Object object) {
        SchedulingPolicy p;
        if (object instanceof SchedulingPolicy && (p = (SchedulingPolicy)object).getPolicy() != SchedPolicyKind.UNDEF) {
            return p.getName();
        }
        return super.getTypeText(object);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Scheduler.class)) {
            case 16: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(GrmPackage.Literals.SCHEDULER__POLICY, GrmFactory.eINSTANCE.createSchedulingPolicy()));
        SchedPolicyKind[] schedPolicyKindArray = SchedPolicyKind.values();
        int n = schedPolicyKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            SchedPolicyKind p = schedPolicyKindArray[n2];
            if (p != SchedPolicyKind.OTHER && p != SchedPolicyKind.UNDEF) {
                SchedulingPolicy aSched = GrmFactory.eINSTANCE.createSchedulingPolicy(p);
                newChildDescriptors.add(this.createChildParameter(GrmPackage.Literals.SCHEDULER__POLICY, aSched));
            }
            ++n2;
        }
        newChildDescriptors.add(this.createChildParameter(GrmPackage.Literals.SCHEDULER__POLICY, LibraryFactory.eINSTANCE.createTDMA()));
        newChildDescriptors.add(this.createChildParameter(GrmPackage.Literals.SCHEDULER__POLICY, LibraryFactory.eINSTANCE.createDeadlineMonotonicSchedulingPolicy()));
        newChildDescriptors.add(this.createChildParameter(GrmPackage.Literals.SCHEDULER__POLICY, LibraryFactory.eINSTANCE.createRateMonotonicSchedulingPolicy()));
    }

    @Override
    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == GrmPackage.Literals.RESOURCE__OWNED_RESOURCE || childFeature == GrmPackage.Literals.RESOURCE__OWNED_PORT || childFeature == GrmPackage.Literals.RESOURCE_BROKER__ACC_CTRL_POLICY || childFeature == GrmPackage.Literals.SCHEDULER__POLICY;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }
}

