/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SliceKind implements Enumerator
{
    OTHER(0, "OTHER", "OTHER"),
    TASK(1, "TASK", "TASK"),
    JOB(2, "JOB", "JOB"),
    FUNCTION(3, "FUNCTION", "FUNCTION"),
    FUNCTION_INSTANCE(4, "FUNCTION_INSTANCE", "FUNCTION_INSTANCE"),
    PACKET(5, "PACKET", "PACKET"),
    FRAME(6, "FRAME", "FRAME"),
    LINK(7, "LINK", "LINK"),
    RESOURCE(9, "RESOURCE", "RESOURCE"),
    STATE(9, "STATE", "STATE"),
    AUTOMATON(10, "AUTOMATON", "AUTOMATON"),
    TEMPORAL_CHAIN(11, "TEMPORAL_CHAIN", "TEMPORAL_CHAIN"),
    OS(12, "OS", "OS");

    public static final int OTHER_VALUE = 0;
    public static final int TASK_VALUE = 1;
    public static final int JOB_VALUE = 2;
    public static final int FUNCTION_VALUE = 3;
    public static final int FUNCTION_INSTANCE_VALUE = 4;
    public static final int PACKET_VALUE = 5;
    public static final int FRAME_VALUE = 6;
    public static final int LINK_VALUE = 7;
    public static final int RESOURCE_VALUE = 9;
    public static final int STATE_VALUE = 9;
    public static final int AUTOMATON_VALUE = 10;
    public static final int TEMPORAL_CHAIN_VALUE = 11;
    public static final int OS_VALUE = 12;
    private static final SliceKind[] VALUES_ARRAY;
    public static final List<SliceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SliceKind[]{OTHER, TASK, JOB, FUNCTION, FUNCTION_INSTANCE, PACKET, FRAME, LINK, RESOURCE, STATE, AUTOMATON, TEMPORAL_CHAIN, OS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SliceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SliceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SliceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SliceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SliceKind get(int value) {
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return TASK;
            }
            case 2: {
                return JOB;
            }
            case 3: {
                return FUNCTION;
            }
            case 4: {
                return FUNCTION_INSTANCE;
            }
            case 5: {
                return PACKET;
            }
            case 6: {
                return FRAME;
            }
            case 7: {
                return LINK;
            }
            case 9: {
                return RESOURCE;
            }
            case 10: {
                return AUTOMATON;
            }
            case 11: {
                return TEMPORAL_CHAIN;
            }
            case 12: {
                return OS;
            }
        }
        return null;
    }

    private SliceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

