/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.marte.gqam.InputPin;
import org.polarsys.time4sys.marte.gqam.OutputPin;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.AbstractTransformation;
import org.polarsys.time4sys.transformations.TaskDuplicator;

public class TaskSplitter
extends AbstractTransformation {
    public static final String COPY_TASK_ROLE = "copy-task";
    public static final String ORIGINAL_TASK_ROLE = "original-task";
    public static final String TRANS_NAME = ("Normal Form " + TaskSplitter.class.getSimpleName()).intern();
    public static final String STEPNTASK_TRANS_NAME = ("one step to one task AND one step Rule " + TaskSplitter.class.getSimpleName()).intern();
    public static final String TASK_TRANS_NAME = ("one duplicated task Rule " + TaskSplitter.class.getSimpleName()).intern();
    private Collection<Step> sourceStepsStartOfTask = new LinkedHashSet<Step>();
    private Collection<Link> tasksToBeCopied = new LinkedHashSet<Link>();
    private Map<SchedulableResource, Collection<SchedulableResource>> tasksToBeLinked = new HashMap<SchedulableResource, Collection<SchedulableResource>>();
    private Context stepNTaskRule;
    private Context taskDuplicationRule;
    private Collection<SchedulableResource> targetTasksToBeRemoved = new LinkedHashSet<SchedulableResource>();
    protected final TaskSplitterConfiguration config;

    public static Transformation transform(Project project, DesignModel source) {
        return TaskSplitter.transform(TaskSplitter.defaultCfg(), project, source);
    }

    public static Transformation transform(TaskSplitterConfiguration cfg, Project project, DesignModel source) {
        return new TaskSplitter(cfg, project, source).transform();
    }

    public static TaskSplitterConfiguration defaultCfg() {
        return new TaskSplitterConfiguration();
    }

    public TaskSplitter(TaskSplitterConfiguration cfg, Project project, DesignModel source) {
        super(project, source, TRANS_NAME);
        this.config = cfg;
    }

    @Override
    public void createRules() {
        super.createRules();
        this.stepNTaskRule = mappingFactory.createContext(STEPNTASK_TRANS_NAME);
        this.taskDuplicationRule = mappingFactory.createContext(TASK_TRANS_NAME);
        this.mapping.getRules().add((Object)this.stepNTaskRule);
        this.mapping.getRules().add((Object)this.taskDuplicationRule);
    }

    @Override
    public void copied(EObject source, Link lnk, EObject theCopy) {
        if (theCopy instanceof Step) {
            Step aStep = (Step)source;
            if (aStep.getCause().isEmpty()) {
                if (aStep.getInputPin().isEmpty()) {
                    this.sourceStepsStartOfTask.add(aStep);
                }
            } else {
                this.sourceStepsStartOfTask.add(aStep);
            }
            if (!aStep.getInputPin().isEmpty()) {
                for (Step sourceStep : this.collectPredecessorsStep(aStep)) {
                    if (aStep.getConcurRes() == sourceStep.getConcurRes()) continue;
                    this.sourceStepsStartOfTask.add(aStep);
                }
            }
            if (!aStep.getOutputPin().isEmpty()) {
                boolean atLeastOneOutgoingCrossFlow = false;
                for (Step targetStep : this.collectSuccessorsStep(aStep)) {
                    if (aStep.getConcurRes() == targetStep.getConcurRes()) continue;
                    this.sourceStepsStartOfTask.add(targetStep);
                    atLeastOneOutgoingCrossFlow = true;
                }
                if (atLeastOneOutgoingCrossFlow) {
                    this.sourceStepsStartOfTask.addAll(this.collectSuccessorsStep(aStep));
                }
            }
        }
    }

    @Override
    protected void finalize(DesignModel target) {
        LinkedHashSet<Step> targetStepstoExplore = new LinkedHashSet<Step>();
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        LinkedHashSet<Step> targetStepsStartOfTask = new LinkedHashSet<Step>();
        for (Step aStep : this.sourceStepsStartOfTask) {
            EList linksForSourceStep = this.mapping.getLinksForSource((EObject)aStep);
            for (Link lnk : linksForSourceStep) {
                EObject copy;
                if (lnk.getRationale() != this.identityRule || (copy = lnk.getUniqueTargetValue(COPY_ROLE)) == null || !(copy instanceof Step)) continue;
                Step copyStep = (Step)copy;
                targetStepsStartOfTask.add(copyStep);
                this.targetTasksToBeRemoved.add(copyStep.getConcurRes());
                TaskDuplicator.moveStepToNewTask(this.tasksToBeLinked, copier, lnk, this.stepNTaskRule);
                targetStepstoExplore.addAll(this.collectSuccessorsStep(copyStep));
            }
        }
        targetStepstoExplore.removeAll(targetStepsStartOfTask);
        LinkedList<Object> waveFront = new LinkedList<Object>(targetStepstoExplore);
        while (!waveFront.isEmpty()) {
            Step copyStep = (Step)waveFront.poll();
            Collection<SchedulableResource> predTasks = this.collectPredecessorsTask(copyStep);
            LinkedList<SchedulableResource> unmigratedPredTasks = new LinkedList<SchedulableResource>(predTasks);
            unmigratedPredTasks.retainAll(this.targetTasksToBeRemoved);
            if (unmigratedPredTasks.isEmpty()) {
                if (predTasks.size() == 1) {
                    copyStep.setConcurRes(predTasks.iterator().next());
                } else {
                    EList linksForSourceStep = this.mapping.getLinksForSlice((EObject)copyStep);
                    for (Link currentLnk : linksForSourceStep) {
                        if (currentLnk.getRationale() != this.identityRule) continue;
                        TaskDuplicator.moveStepToNewTask(this.tasksToBeLinked, copier, currentLnk, this.stepNTaskRule);
                    }
                }
                waveFront.addAll(this.collectUnmigratedSuccessorsStep(copyStep, this.targetTasksToBeRemoved));
                continue;
            }
            waveFront.add(copyStep);
        }
        copier.copyReferences();
        this.tasksToBeCopied = this.collectLinkFor(this.targetTasksToBeRemoved);
        if (this.config.indexBasedName) {
            this.renameTasksWithIndex();
        }
        TaskDuplicator.deleteCopiedTasks(this.targetTasksToBeRemoved, this.tasksToBeLinked, this.tasksToBeCopied, this.taskDuplicationRule);
    }

    private void renameTasksWithIndex() {
        EList tasksLnk = this.mapping.getLinks(this.stepNTaskRule);
        HashMap<SchedulableResource, Integer> perTaskCounter = new HashMap<SchedulableResource, Integer>();
        for (Link lnk : tasksLnk) {
            if (lnk.getRationale() != this.stepNTaskRule) continue;
            EObject source = lnk.getUniqueSourceValue(ORIGINAL_TASK_ROLE);
            assert (source instanceof SchedulableResource);
            SchedulableResource sourceTask = (SchedulableResource)source;
            int counter = perTaskCounter.getOrDefault(sourceTask, 0);
            String prefix = sourceTask.getName();
            for (EObject target : lnk.getTargets(COPY_TASK_ROLE)) {
                assert (target instanceof SchedulableResource);
                ((SchedulableResource)target).setName(String.valueOf(prefix) + "_" + Integer.toString(++counter));
            }
            perTaskCounter.put(sourceTask, counter);
        }
    }

    private Collection<? extends Step> collectUnmigratedSuccessorsStep(Step copyStep, Collection<SchedulableResource> targetTasksToBeRemoved) {
        LinkedHashSet<Step> result = new LinkedHashSet<Step>();
        for (Step aStep : this.collectSuccessorsStep(copyStep)) {
            if (!targetTasksToBeRemoved.contains(aStep.getConcurRes())) continue;
            result.add(aStep);
        }
        return result;
    }

    private Collection<Link> collectLinkFor(Collection<SchedulableResource> targetTasks) {
        LinkedHashSet<Link> lnks = new LinkedHashSet<Link>();
        for (SchedulableResource res : targetTasks) {
            lnks.addAll((Collection<Link>)this.mapping.getLinksForSlice((EObject)res));
        }
        return lnks;
    }

    protected Collection<SchedulableResource> collectPredecessorsTask(Step targetStep) {
        LinkedHashSet<SchedulableResource> tasks = new LinkedHashSet<SchedulableResource>();
        for (Step predStep : this.collectPredecessorsStep(targetStep)) {
            tasks.add(predStep.getConcurRes());
        }
        return tasks;
    }

    protected Collection<Step> collectPredecessorsStep(Step targetStep) {
        LinkedHashSet<Step> steps = new LinkedHashSet<Step>();
        for (InputPin ipin : targetStep.getInputPin()) {
            for (OutputPin opin : ipin.getPredecessors()) {
                if (!(opin.eContainer() instanceof Step)) continue;
                steps.add((Step)opin.eContainer());
            }
        }
        return steps;
    }

    protected Collection<Step> collectSuccessorsStep(Step targetStep) {
        LinkedHashSet<Step> steps = new LinkedHashSet<Step>();
        for (OutputPin opin : targetStep.getOutputPin()) {
            for (InputPin ipin : opin.getSuccessors()) {
                if (!(ipin.eContainer() instanceof Step)) continue;
                steps.add((Step)ipin.eContainer());
            }
        }
        return steps;
    }

    public static class TaskSplitterConfiguration {
        protected boolean indexBasedName;

        public TaskSplitterConfiguration() {
            this.indexBasedName = false;
        }

        public TaskSplitterConfiguration(TaskSplitterConfiguration original) {
            this.indexBasedName = original.indexBasedName;
        }

        public TaskSplitterConfiguration namesAreIndexBased() {
            TaskSplitterConfiguration result = new TaskSplitterConfiguration(this);
            result.indexBasedName = true;
            return result;
        }
    }
}

