/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.time4sys.marte.nfp.coreelements.ModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteHandler
extends AbstractHandler {
    private Session collectSessionAndFillSelection(ISelection selection, List<ModelElement> selected) {
        Session session = null;
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ModelElement) {
                    selected.add((ModelElement)obj);
                    if (session == null) {
                        session = SessionManager.INSTANCE.getSession((EObject)((ModelElement)obj));
                    }
                }
                ++n2;
            }
        }
        return session;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<ModelElement> selected;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Session session = this.collectSessionAndFillSelection(selection, selected = new ArrayList<ModelElement>());
        if (session != null) {
            RecordingCommand cmd = new RecordingCommand(session.getTransactionalEditingDomain(), "Delete from model"){

                protected void doExecute() {
                    for (ModelElement element : selected) {
                        DeleteHandler.this.destroy((EObject)element);
                    }
                    Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
                    for (DRepresentation representation : representations) {
                        DSemanticDiagram diagram;
                        if (!(representation instanceof DSemanticDiagram) || (diagram = (DSemanticDiagram)representation).getTarget() == null || !DialectManager.INSTANCE.canRefresh(representation)) continue;
                        DialectManager.INSTANCE.refresh(representation, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            };
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
        }
        return null;
    }

    public void destroy(EObject ancestorEObject) {
        if (ancestorEObject.eContents().isEmpty()) {
            if (ancestorEObject instanceof ModelElement) {
                this.removeReferences(ancestorEObject, ancestorEObject);
                ancestorEObject.eAdapters().clear();
            } else {
                this.removeReferences(ancestorEObject, null);
            }
        } else {
            EObject eObject;
            TreeIterator allContents = EcoreUtil.getAllContents((EObject)ancestorEObject, (boolean)true);
            while (allContents.hasNext()) {
                EObject cfr_ignored_0 = (EObject)allContents.next();
            }
            allContents = EcoreUtil.getAllContents((EObject)ancestorEObject, (boolean)true);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (eObject instanceof ModelElement) {
                    this.removeReferences(eObject, ancestorEObject);
                    continue;
                }
                this.removeReferences(eObject, null);
            }
            allContents = EcoreUtil.getAllContents((EObject)ancestorEObject, (boolean)true);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (!(eObject instanceof ModelElement)) continue;
                eObject.eAdapters().clear();
            }
        }
        EcoreUtil.remove((EObject)ancestorEObject);
    }

    private void removeReferences(EObject eObject, EObject ancestorEObject) {
        for (EStructuralFeature.Setting inverseReference : new ArrayList<EStructuralFeature.Setting>(this.getInverseReferences(eObject))) {
            if (!inverseReference.getEStructuralFeature().isChangeable() || ancestorEObject != null && EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)inverseReference.getEObject())) continue;
            EcoreUtil.remove((EStructuralFeature.Setting)inverseReference, (Object)eObject);
        }
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            if (!eReference.isChangeable() || eReference.isContainer() || eReference.isContainment() || eReference.isDerived() || !eObject.eIsSet((EStructuralFeature)eReference)) continue;
            if (eReference.isMany()) {
                List values = (List)eObject.eGet((EStructuralFeature)eReference);
                int i = 0;
                while (i < values.size()) {
                    Object value = values.get(i);
                    if (ancestorEObject == null || !EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)((EObject)value))) {
                        values.remove(i);
                    }
                    ++i;
                }
                continue;
            }
            if (ancestorEObject != null && EcoreUtil.isAncestor((EObject)ancestorEObject, (EObject)((EObject)eObject.eGet((EStructuralFeature)eReference)))) continue;
            eObject.eUnset((EStructuralFeature)eReference);
        }
    }

    private Collection<EStructuralFeature.Setting> getInverseReferences(EObject eObject) {
        ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eObject);
        return crossReferenceAdapter == null ? Collections.emptyList() : crossReferenceAdapter.getInverseReferences(eObject);
    }
}

