/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core.parser;

import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import com.microsoft.jdtls.ext.core.PackageCommand;
import com.microsoft.jdtls.ext.core.parser.ResourceVisitor;
import java.net.URI;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;

public class ResourceSet {
    private List<Object> resources;
    private boolean isHierarchicalView;

    public ResourceSet(List<Object> resources) {
        this(resources, false);
    }

    public ResourceSet(List<Object> resources, boolean isHierarchicalView) {
        this.resources = resources;
        this.isHierarchicalView = isHierarchicalView;
    }

    public void accept(ResourceVisitor visitor) {
        ListIterator<Object> iterator = this.resources.listIterator();
        while (iterator.hasNext()) {
            Object resource = iterator.next();
            if (resource == null) continue;
            if (resource instanceof IClasspathEntry) {
                visitor.visit((IClasspathEntry)resource);
                continue;
            }
            if (resource instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)resource;
                IJavaProject javaProject = pkgRoot.getJavaProject();
                if (javaProject == null) continue;
                if (ProjectUtils.isUnmanagedFolder((IProject)javaProject.getProject()) && Objects.equals("_", pkgRoot.getElementName())) {
                    try {
                        List<Object> nextObjs = PackageCommand.getPackageFragmentRootContent(pkgRoot, this.isHierarchicalView, (IProgressMonitor)new NullProgressMonitor());
                        for (Object nextObj : nextObjs) {
                            iterator.add(nextObj);
                            iterator.previous();
                        }
                    }
                    catch (CoreException e) {
                        JdtlsExtActivator.logException("Failed to get package fragment root content", e);
                    }
                    continue;
                }
                visitor.visit(pkgRoot);
                continue;
            }
            if (resource instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)resource;
                if (fragment.isDefaultPackage()) {
                    List<Object> nextObjs = PackageCommand.getChildrenForPackage(fragment, (IProgressMonitor)new NullProgressMonitor());
                    for (Object nextObj : nextObjs) {
                        iterator.add(nextObj);
                        iterator.previous();
                    }
                    continue;
                }
                visitor.visit(fragment);
                continue;
            }
            if (resource instanceof IType) {
                visitor.visit((IType)resource);
                continue;
            }
            if (resource instanceof IClassFile) {
                visitor.visit((IClassFile)resource);
                continue;
            }
            if (resource instanceof ICompilationUnit) {
                visitor.visit((ICompilationUnit)resource);
                continue;
            }
            if (resource instanceof IFile) {
                if (!this.shouldVisit((IResource)((IFile)resource))) continue;
                visitor.visit((IFile)resource);
                continue;
            }
            if (resource instanceof IFolder) {
                if (!this.shouldVisit((IResource)((IFolder)resource))) continue;
                visitor.visit((IFolder)resource);
                continue;
            }
            if (!(resource instanceof IJarEntryResource)) continue;
            visitor.visit((IJarEntryResource)resource);
        }
    }

    private boolean shouldVisit(IResource resource) {
        IPath resourcePath;
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IPath projectRealFolder = ProjectUtils.getProjectRealFolder((IProject)project.getProject());
        if (!projectRealFolder.isPrefixOf(resourcePath = FileUtil.toPath((URI)resource.getLocationURI()))) {
            return false;
        }
        if (Objects.equals(projectRealFolder, resourcePath) && Objects.equals("_", resource.getName())) {
            return false;
        }
        return JavaCore.create((IResource)resource) == null;
    }
}

