/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.io.File;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;

public class TroubleshootingInfoCommand {
    public static final String GET_TROUBLESHOOTING_INFO_COMMAND = "java.getTroubleshootingInfo";

    private TroubleshootingInfoCommand() {
    }

    public static final TroubleshootingInfo getTroubleshootingInfo() {
        return new TroubleshootingInfo();
    }

    public static final class TroubleshootingInfo {
        public String mavenUserSettings;
        public String mavenGlobalSettings;
        public String gradleJavaHome;
        public String gradleUserHome;
        public String[] activeImporters;

        public TroubleshootingInfo() {
            File globalSettings;
            IMavenConfiguration config = IMavenConfiguration.getWorkspaceConfiguration();
            File userSettings = config.getSettingsLocations().userSettings();
            if (userSettings != null) {
                this.mavenUserSettings = userSettings.toString();
            }
            if ((globalSettings = config.getSettingsLocations().globalSettings()) != null) {
                this.mavenGlobalSettings = config.getSettingsLocations().globalSettings().toString();
            }
            this.activeImporters = (String[])ProjectsManager.importers().stream().map(importer -> importer.getClass().getName()).toArray(String[]::new);
            Preferences prefs = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
            this.gradleJavaHome = prefs.getGradleJavaHome();
            this.gradleUserHome = prefs.getGradleUserHome();
        }
    }
}

