/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PlaceholderReplacer {
    public static <T> void replaceAll(Collection<T> spanList, Function<String, String> mapper, char openPlaceholder, char closePlaceholder, Function<T, String> getter, BiConsumer<T, String> setter) {
        if (spanList.isEmpty()) {
            return;
        }
        StringBuilder sb = null;
        for (T span : spanList) {
            String textValue = getter.apply(span);
            int length = textValue.length();
            int lastPos = 0;
            StringBuilder plainText = null;
            while (lastPos < length) {
                int pos;
                if (sb == null) {
                    pos = textValue.indexOf(openPlaceholder, lastPos);
                    if (pos == -1) {
                        if (lastPos <= 0) break;
                        if (plainText != null) {
                            plainText.append(textValue.substring(lastPos));
                            break;
                        }
                        setter.accept(span, textValue.substring(lastPos));
                        break;
                    }
                    sb = new StringBuilder();
                    if (lastPos < pos) {
                        if (plainText == null) {
                            plainText = new StringBuilder();
                        }
                        plainText.append(textValue.substring(lastPos, pos));
                    }
                    if ((lastPos = pos + 1) < length || plainText != null) continue;
                    setter.accept(span, "");
                    continue;
                }
                pos = textValue.indexOf(closePlaceholder, lastPos);
                if (pos == -1) {
                    sb.append(textValue.substring(lastPos));
                    if (plainText == null) {
                        setter.accept(span, "");
                    }
                    lastPos = length;
                    continue;
                }
                sb.append(textValue.substring(lastPos, pos));
                lastPos = pos + 1;
                String placeholder = sb.toString();
                Object result = mapper.apply(placeholder);
                sb = null;
                if (result == null) {
                    result = openPlaceholder + placeholder + closePlaceholder;
                }
                if (plainText == null) {
                    plainText = new StringBuilder();
                }
                plainText.append((String)result);
            }
            if (plainText == null) continue;
            setter.accept(span, plainText.toString());
        }
    }
}

