/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class MethodReferenceSearchRequestor
implements ITypeRequestor {
    protected final SearchRequestor requestor;
    protected final SearchParticipant participant;
    protected final String methodName;
    protected final String declaringTypeName;
    protected final String[] parameterTypeNames;
    protected final String[] parameterTypeSignatures;
    protected final boolean findReferences;
    protected final boolean findDeclarations;
    protected final boolean skipPseudoProperties;
    protected final Set<Position> acceptedPositions = new HashSet<Position>();
    protected static final int MAX_PARAMS = 20;
    protected final Map<ClassNode, BitSet> cachedParameterCounts = new HashMap<ClassNode, BitSet>();
    protected final Map<ClassNode, Boolean> cachedDeclaringNameMatches = new HashMap<ClassNode, Boolean>();

    public MethodReferenceSearchRequestor(MethodPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.methodName = String.valueOf(pattern.selector);
        this.parameterTypeSignatures = MethodReferenceSearchRequestor.getParameterTypeSignatures(pattern);
        IType declaringType = (IType)ReflectionUtils.getPrivateField(MethodPattern.class, "declaringType", pattern);
        char[] declaringQualifiedName = null;
        try {
            if (pattern.focus instanceof IMethod && MethodReferenceSearchRequestor.supportsOverride((IMethod)pattern.focus)) {
                LinkedList<IMethod> methods = new LinkedList<IMethod>();
                if (declaringType == null) {
                    declaringType = ((IMethod)pattern.focus).getDeclaringType();
                }
                IType[] iTypeArray = declaringType.newSupertypeHierarchy(null).getAllSupertypes(declaringType);
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType superType = iTypeArray[n2];
                    IMethod superMeth = superType.getMethod(this.methodName, this.parameterTypeSignatures);
                    if (superMeth.exists() && MethodReferenceSearchRequestor.supportsOverride(superMeth)) {
                        methods.add(superMeth);
                    }
                    ++n2;
                }
                if (!methods.isEmpty()) {
                    IType type = ((IMethod)methods.getLast()).getDeclaringType();
                    char[] superTypeName = type.getElementName().toCharArray();
                    char[] packageName = type.getPackageFragment().getElementName().toCharArray();
                    declaringQualifiedName = CharOperation.concat(packageName, superTypeName, '.');
                }
            }
        }
        catch (Exception e) {
            Util.log(e);
        }
        if (declaringQualifiedName == null && (declaringQualifiedName = CharOperation.concat(pattern.declaringQualification, pattern.declaringSimpleName, '.')) == null) {
            declaringQualifiedName = declaringType != null ? CharOperation.concat(declaringType.getPackageFragment().getElementName().toCharArray(), declaringType.getElementName().toCharArray(), '.') : CharOperation.NO_CHAR;
        }
        this.declaringTypeName = String.valueOf(declaringQualifiedName);
        this.parameterTypeNames = MethodReferenceSearchRequestor.getParameterTypeNames(pattern, this.parameterTypeSignatures, declaringType);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findReferences", pattern);
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(MethodPattern.class, "findDeclarations", pattern);
        this.skipPseudoProperties = requestor.getClass().getName().equals("org.eclipse.jdt.internal.corext.refactoring.rename.MethodOccurenceCollector");
    }

    protected static String[] getParameterTypeNames(MethodPattern pattern, String[] parameterTypeSignatures, IType declaringType) {
        if (pattern.parameterCount < 0) {
            return null;
        }
        int n = parameterTypeSignatures.length;
        String[] typeNames = new String[n];
        if (declaringType != null) {
            try {
                int candidates = 0;
                if (n > 0) {
                    IMethod[] iMethodArray = declaringType.getMethods();
                    int n2 = iMethodArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IMethod m = iMethodArray[n3];
                        if (MethodReferenceSearchRequestor.equal(pattern.selector, m.getElementName()) && n == m.getNumberOfParameters()) {
                            ++candidates;
                        }
                        ++n3;
                    }
                }
                if (candidates > 1) {
                    int i = 0;
                    while (i < n) {
                        if (pattern.parameterQualifications[i] != null || MethodReferenceSearchRequestor.isPrimitiveType(pattern.parameterSimpleNames[i])) {
                            typeNames[i] = String.valueOf(CharOperation.concat(pattern.parameterQualifications[i], pattern.parameterSimpleNames[i], '.'));
                        } else {
                            int arrayCount = Signature.getArrayCount(parameterTypeSignatures[i]);
                            String[][] resolved = declaringType.resolveType(String.valueOf(pattern.parameterSimpleNames[i], 0, pattern.parameterSimpleNames[i].length - 2 * arrayCount));
                            if (resolved != null) {
                                typeNames[i] = Signature.toQualifiedName(resolved[0]);
                                if (typeNames[i].charAt(0) == '.') {
                                    typeNames[i] = typeNames[i].substring(1);
                                }
                            } else {
                                typeNames[i] = String.valueOf(pattern.parameterSimpleNames[i]);
                            }
                            while (arrayCount-- > 0) {
                                int n4 = i;
                                typeNames[n4] = String.valueOf(typeNames[n4]) + "[]";
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Util.log(e);
            }
        }
        return typeNames;
    }

    protected static String[] getParameterTypeSignatures(MethodPattern pattern) {
        if (pattern.parameterCount < 0) {
            return null;
        }
        char[][][] signatures = (char[][][])ReflectionUtils.getPrivateField(MethodPattern.class, "parametersTypeSignatures", pattern);
        int n = signatures == null ? 0 : signatures.length;
        String[] parameterTypeSignatures = new String[n];
        int i = 0;
        while (i < n) {
            parameterTypeSignatures[i] = String.valueOf(signatures[i][0]);
            ++i;
        }
        return parameterTypeSignatures;
    }

    protected static boolean isPrimitiveType(char[] name) {
        switch (name[0]) {
            case 'i': {
                return name.length >= 3 && name[1] == 'n' && name[2] == 't' && (name.length == 3 || name[3] == '[');
            }
            case 'l': {
                return name.length >= 4 && name[1] == 'o' && name[2] == 'n' && name[3] == 'g' && (name.length == 4 || name[4] == '[');
            }
            case 'c': {
                return name.length >= 4 && name[1] == 'h' && name[2] == 'a' && name[3] == 'r' && (name.length == 4 || name[4] == '[');
            }
            case 's': {
                return name.length >= 5 && name[1] == 'h' && name[2] == 'o' && name[3] == 'r' && name[4] == 't' && (name.length == 5 || name[5] == '[');
            }
            case 'f': {
                return name.length >= 5 && name[1] == 'l' && name[2] == 'o' && name[3] == 'a' && name[4] == 't' && (name.length == 5 || name[5] == '[');
            }
            case 'd': {
                return name.length >= 6 && name[1] == 'o' && name[2] == 'u' && name[3] == 'b' && name[4] == 'l' && name[5] == 'e' && (name.length == 6 || name[6] == '[');
            }
            case 'b': {
                if (name.length >= 4 && name[1] == 'y' && name[2] == 't' && name[3] == 'e' && (name.length == 4 || name[4] == '[')) {
                    return true;
                }
                if (name.length < 7 || name[1] != 'o' || name[2] != 'o' || name[3] != 'l' || name[4] != 'e' || name[5] != 'a' || name[6] != 'n' || name.length != 7 && name[7] != '[') break;
                return true;
            }
            case 'v': {
                return name.length == 4 && name[1] == 'o' && name[2] == 'i' && name[3] == 'd';
            }
        }
        return false;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        boolean acceptable;
        Position position;
        if (result.declaringType == null || !(result.declaration instanceof MethodNode)) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        boolean isDeclaration = node instanceof MethodNode;
        int start = 0;
        int end = 0;
        if (this.methodName.equals(((MethodNode)result.declaration).getName())) {
            if (isDeclaration || node instanceof StaticMethodCallExpression) {
                start = ((AnnotatedNode)node).getNameStart();
                end = ((AnnotatedNode)node).getNameEnd() + 1;
                if (!isDeclaration && this.skipPseudoProperties && (MethodReferenceSearchRequestor.isStaticImportAlias(node) || end - start < ((StaticMethodCallExpression)node).getMethod().length())) {
                    start = 0;
                    end = 0;
                } else if (end < 1 && isDeclaration && ((MethodNode)node).isStatic() && "main".equals(this.methodName)) {
                    end = 1;
                }
            } else if (this.methodName.equals(node.getText()) && !MethodReferenceSearchRequestor.isStaticImportAlias(result.scope.getEnclosingNode()) || !this.skipPseudoProperties && !((MethodNode)result.declaration).isSynthetic()) {
                start = node.getStart();
                end = node.getEnd();
            }
        } else if (this.methodName.equals(node.getText()) && (node instanceof ConstantExpression || node instanceof VariableExpression) && this.parameterTypesMatch((MethodNode)result.declaration)) {
            start = node.getStart();
            end = node.getEnd();
        }
        if (end > 0 && !this.acceptedPositions.contains(position = new Position(start, end - start)) && this.declaringTypeMatches(result.declaringType) && (acceptable = isDeclaration || result.confidence == TypeLookupResult.TypeConfidence.EXACT ? this.parameterTypesMatch((MethodNode)result.declaration) : this.argumentTypesMatch(result.scope.getMethodCallArgumentTypes(), result.declaringType))) {
            if (enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy) {
                enclosingElement = ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement);
            }
            SearchMatch match = null;
            if (isDeclaration && this.findDeclarations) {
                match = new MethodDeclarationMatch(enclosingElement, this.getAccuracy(result.confidence), start, end - start, this.participant, enclosingElement.getResource());
            } else if (!isDeclaration && this.findReferences) {
                match = new MethodReferenceMatch(enclosingElement, this.getAccuracy(result.confidence), start, end - start, false, false, false, false, this.participant, enclosingElement.getResource());
            }
            if (match != null) {
                try {
                    this.acceptedPositions.add(position);
                    this.requestor.acceptSearchMatch(match);
                }
                catch (Exception e) {
                    Util.log(e, "Error reporting search match inside of " + enclosingElement + " in resource " + enclosingElement.getResource());
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean declaringTypeMatches(ClassNode declaringType) {
        if (declaringType == null) {
            return false;
        }
        String declaringTypeName = declaringType.getName().replace('$', '.');
        if ("java.lang.Object".equals(declaringTypeName) && declaringType.getDeclaredMethods(this.methodName).isEmpty()) {
            return false;
        }
        if (this.declaringTypeName == null || this.declaringTypeName.isEmpty()) {
            return true;
        }
        Boolean maybeMatch = this.cachedDeclaringNameMatches.get(declaringType);
        if (maybeMatch != null) {
            return maybeMatch;
        }
        if (declaringTypeName.equals(this.declaringTypeName)) {
            this.cachedDeclaringNameMatches.put(declaringType, Boolean.TRUE);
            return true;
        }
        maybeMatch = this.declaringTypeMatches(declaringType.getSuperClass());
        if (!maybeMatch.booleanValue()) {
            ClassNode[] classNodeArray = declaringType.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode face = classNodeArray[n2];
                maybeMatch = this.declaringTypeMatches(face);
                if (maybeMatch.booleanValue()) break;
                ++n2;
            }
        }
        this.cachedDeclaringNameMatches.put(declaringType, maybeMatch);
        return maybeMatch;
    }

    private boolean parameterTypesMatch(MethodNode methodNode) {
        if (this.parameterTypeSignatures != null) {
            Parameter[] parameters = methodNode == methodNode.getOriginal() || MethodReferenceSearchRequestor.parameterCountOf(methodNode) != MethodReferenceSearchRequestor.parameterCountOf(methodNode.getOriginal()) ? methodNode.getParameters() : methodNode.getOriginal().getParameters();
            List<ClassNode> parameterTypes = GroovyUtils.getParameterTypes(parameters);
            int n = parameterTypes.size();
            if (n != this.parameterTypeSignatures.length) {
                return false;
            }
            int i = 0;
            while (i < n) {
                ClassNode parameterType = parameterTypes.get(i);
                String parameterTypeSignature = Signature.getTypeErasure(this.parameterTypeSignatures[i]);
                if (!(GroovyUtils.getTypeSignatureWithoutGenerics(parameterType, false, false).equals(parameterTypeSignature) || !ClassHelper.isPrimitiveType(parameterType) && GroovyUtils.getTypeSignatureWithoutGenerics(parameterType, true, false).equals(parameterTypeSignature))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean argumentTypesMatch(List<ClassNode> argumentTypes, ClassNode declaringType) {
        if (argumentTypes == null || this.parameterTypeNames == null) {
            return true;
        }
        if (argumentTypes.size() == this.parameterTypeNames.length) {
            int i = 0;
            while (i < this.parameterTypeNames.length) {
                ClassNode target;
                ClassNode source;
                if (this.parameterTypeNames[i] != null && Boolean.FALSE.equals(SimpleTypeLookup.isTypeCompatible(source = argumentTypes.get(i), target = GroovyUtils.makeType(this.parameterTypeNames[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        BitSet foundParameterCounts = this.cachedParameterCounts.computeIfAbsent(declaringType, t -> {
            BitSet parameterCounts = new BitSet(21);
            this.gatherParameters(declaringType, parameterCounts);
            return parameterCounts;
        });
        return !foundParameterCounts.get(Math.min(20, argumentTypes.size()));
    }

    private void gatherParameters(ClassNode declaringType, BitSet foundParameterCounts) {
        if (declaringType != null) {
            declaringType = MethodReferenceSearchRequestor.findWrappedNode(declaringType.redirect());
            List<MethodNode> methods = declaringType.getMethods(this.methodName);
            for (MethodNode method : methods) {
                Parameter[] parameters = method.getParameters();
                foundParameterCounts.set(Math.min(parameters.length, 20));
            }
            this.gatherParameters(declaringType.getSuperClass(), foundParameterCounts);
            ClassNode[] classNodeArray = declaringType.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode face = classNodeArray[n2];
                this.gatherParameters(face, foundParameterCounts);
                ++n2;
            }
        }
    }

    private static ClassNode findWrappedNode(ClassNode declaringType) {
        ReferenceBinding binding;
        ClassNode wrappedNode = null;
        if (declaringType instanceof JDTClassNode && (binding = ((JDTClassNode)declaringType).getJdtBinding()) instanceof SourceTypeBinding) {
            TypeDeclaration typeDeclaration;
            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
            if (sourceTypeBinding.scope != null && (typeDeclaration = sourceTypeBinding.scope.referenceContext) instanceof GroovyTypeDeclaration) {
                GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typeDeclaration;
                wrappedNode = groovyTypeDeclaration.getClassNode();
            }
        }
        return wrappedNode == null ? declaringType : wrappedNode;
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence) {
        if (confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED) || this.requestor.getClass().getName().contains(".callhierarchy.")) {
            return 0;
        }
        return 1;
    }

    private static int parameterCountOf(MethodNode method) {
        return method.getParameters().length;
    }

    private static boolean supportsOverride(IMethod method) throws JavaModelException {
        int flags = method.getFlags();
        return !Flags.isPrivate(flags) && !Flags.isStatic(flags);
    }

    private static boolean isStaticImportAlias(ASTNode node) {
        return node != null && node.getNodeMetaData("static.import.alias") != null;
    }

    private static boolean equal(char[] arr, CharSequence seq) {
        if (arr.length != seq.length()) {
            return false;
        }
        int i = 0;
        int n = arr.length;
        while (i < n) {
            if (arr[i] != seq.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

