/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class InputStreamContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker(InputStreamContentSource.class);
    private final InputStream inputStream;
    private final ByteBufferPool.Sized bufferPool;
    private Runnable demandCallback;
    private Content.Chunk errorChunk;
    private long toRead;
    private boolean closed;

    @Deprecated(since="12.1.0", forRemoval=true)
    public InputStreamContentSource(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamContentSource(InputStream inputStream, ByteBufferPool.Sized bufferPool) {
        this(inputStream, bufferPool, 0L, -1L);
    }

    public InputStreamContentSource(InputStream inputStream, ByteBufferPool.Sized bufferPool, long offset, long length) {
        length = TypeUtil.checkOffsetLengthSize((long)offset, (long)length, (long)-1L);
        this.inputStream = Objects.requireNonNull(inputStream);
        this.bufferPool = Objects.requireNonNullElse(bufferPool, ByteBufferPool.SIZED_NON_POOLING);
        if (length != 0L) {
            InputStreamContentSource.skipToOffset(inputStream, offset);
        }
        this.toRead = length;
    }

    private static void skipToOffset(InputStream inputStream, long offset) {
        if (offset <= 0L) {
            return;
        }
        try {
            inputStream.skipNBytes(offset - 1L);
            if (inputStream.read() == -1) {
                throw new IllegalArgumentException("Offset out of range");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public Content.Chunk read() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk != null) {
                Content.Chunk chunk = this.errorChunk;
                return chunk;
            }
            if (this.closed) {
                Content.Chunk chunk = Content.Chunk.EOF;
                return chunk;
            }
        }
        RetainableByteBuffer.Mutable streamBuffer = this.bufferPool.acquire(false);
        try {
            ByteBuffer buffer = streamBuffer.getByteBuffer();
            int read = this.fillBufferFromInputStream(this.inputStream, buffer.array(), buffer.arrayOffset());
            if (read < 0) {
                streamBuffer.release();
                this.close();
                return Content.Chunk.EOF;
            }
            buffer.limit(read);
            return Content.Chunk.asChunk(buffer, false, streamBuffer);
        }
        catch (Throwable x) {
            streamBuffer.release();
            return this.failure(x);
        }
    }

    protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer, int offset) throws IOException {
        if (this.toRead == 0L) {
            return -1;
        }
        int space = buffer.length - offset;
        int toReadInt = (int)Math.min(Integer.MAX_VALUE, this.toRead);
        int len = toReadInt > 0 ? Math.min(toReadInt, space) : space;
        int read = inputStream.read(buffer, offset, len);
        if (read > 0 && this.toRead > 0L) {
            this.toRead -= (long)read;
        }
        return read;
    }

    private void close() {
        try (AutoLock ignored = this.lock.lock();){
            this.closed = true;
        }
        IO.close((InputStream)this.inputStream);
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.failure(failure);
    }

    private Content.Chunk failure(Throwable failure) {
        Content.Chunk error;
        try (AutoLock ignored = this.lock.lock();){
            error = this.errorChunk;
            if (error == null) {
                error = this.errorChunk = Content.Chunk.from(failure);
            }
        }
        IO.close((InputStream)this.inputStream);
        return error;
    }
}

