"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
const vue_autoinsert_dotvalue_1 = require("./vue-autoinsert-dotvalue");
function create() {
    return {
        name: 'vue-complete-define-assignment',
        capabilities: {
            completionProvider: {},
        },
        create(context) {
            return {
                isAdditionalCompletion: true,
                async provideCompletionItems(document) {
                    if (!(0, vue_autoinsert_dotvalue_1.isTsDocument)(document)) {
                        return;
                    }
                    const enabled = await context.env.getConfiguration?.('vue.complete.defineAssignment') ?? true;
                    if (!enabled) {
                        return;
                    }
                    const result = [];
                    const decoded = context.decodeEmbeddedDocumentUri(vscode_uri_1.URI.parse(document.uri));
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!sourceScript || !virtualCode) {
                        return;
                    }
                    const root = sourceScript?.generated?.root;
                    if (!(root instanceof language_core_1.VueVirtualCode)) {
                        return;
                    }
                    const codegen = language_core_1.tsCodegen.get(root._sfc);
                    const scriptSetup = root._sfc.scriptSetup;
                    const scriptSetupRanges = codegen?.scriptSetupRanges.get();
                    if (!scriptSetup || !scriptSetupRanges) {
                        return;
                    }
                    const mappings = [...context.language.maps.forEach(virtualCode)];
                    addDefineCompletionItem(scriptSetupRanges.props.define && {
                        exp: scriptSetupRanges.props.withDefaults ?? scriptSetupRanges.props.define.exp,
                        statement: scriptSetupRanges.props.define.statement
                    }, 'props');
                    addDefineCompletionItem(scriptSetupRanges.emits.define, 'emit');
                    addDefineCompletionItem(scriptSetupRanges.slots.define, 'slots');
                    return {
                        isIncomplete: false,
                        items: result
                    };
                    function addDefineCompletionItem(define, name) {
                        if (!define || define.exp.start !== define.statement.start) {
                            return;
                        }
                        let offset;
                        for (const [, map] of mappings) {
                            for (const [generatedOffset] of map.toGeneratedLocation(scriptSetup.startTagEnd + define.exp.start)) {
                                offset = generatedOffset;
                                break;
                            }
                        }
                        if (offset === undefined) {
                            return;
                        }
                        const pos = document.positionAt(offset);
                        result.push({
                            label: name,
                            kind: 6,
                            commitCharacters: ['.', ',', ';'],
                            additionalTextEdits: [{
                                    newText: `const ${name} = `,
                                    range: {
                                        start: pos,
                                        end: pos
                                    }
                                }]
                        });
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-complete-define-assignment.js.map