/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyMarginHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyMarginHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSPropertyMarginSWTHandler
extends AbstractCSSPropertyMarginHandler {
    public static final ICSSPropertyMarginHandler INSTANCE = new CSSPropertyMarginSWTHandler();
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        return super.applyCSSProperty(element, property, value, pseudo, engine);
    }

    public void applyCSSPropertyMargin(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            this.setMargin(element, 0, value);
            this.setMargin(element, 1, value);
            this.setMargin(element, 2, value);
            this.setMargin(element, 3, value);
            return;
        }
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            if (length < 2 || length > 4) {
                throw new CSSException("Invalid margin property list length");
            }
            switch (length) {
                case 4: {
                    this.setMargin(element, 0, valueList.item(0));
                    this.setMargin(element, 1, valueList.item(1));
                    this.setMargin(element, 2, valueList.item(2));
                    this.setMargin(element, 3, valueList.item(3));
                    break;
                }
                case 3: {
                    this.setMargin(element, 0, valueList.item(0));
                    this.setMargin(element, 1, valueList.item(1));
                    this.setMargin(element, 2, valueList.item(2));
                    this.setMargin(element, 3, valueList.item(1));
                }
                case 2: {
                    this.setMargin(element, 0, valueList.item(0));
                    this.setMargin(element, 1, valueList.item(1));
                    this.setMargin(element, 2, valueList.item(0));
                    this.setMargin(element, 3, valueList.item(1));
                }
            }
        } else {
            throw new CSSException("Invalid margin property value");
        }
    }

    public void applyCSSPropertyMarginTop(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 0, value);
    }

    public void applyCSSPropertyMarginRight(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 1, value);
    }

    public void applyCSSPropertyMarginBottom(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 2, value);
    }

    public void applyCSSPropertyMarginLeft(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setMargin(element, 3, value);
    }

    public String retrieveCSSPropertyMargin(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyMarginTop(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyMarginRight(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyMarginBottom(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyMarginLeft(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private GridLayout getLayout(Control control) {
        if (control == null) {
            return null;
        }
        Composite parent = control.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getData("org.eclipse.e4.ui.css.swt.marginWrapper") == null) {
            return null;
        }
        Layout layout = parent.getLayout();
        if (layout == null || !(layout instanceof GridLayout)) {
            return null;
        }
        return (GridLayout)layout;
    }

    private void setMargin(Object element, int side, CSSValue value) {
        if (value.getCssValueType() != 1) {
            return;
        }
        int pixelValue = (int)((CSSPrimitiveValue)value).getFloatValue((short)5);
        Widget widget = SWTElementHelpers.getWidget(element);
        if (!(widget instanceof Control)) {
            return;
        }
        GridLayout layout = this.getLayout((Control)widget);
        if (layout == null) {
            return;
        }
        switch (side) {
            case 0: {
                layout.marginTop = pixelValue;
                break;
            }
            case 1: {
                layout.marginRight = pixelValue;
                break;
            }
            case 2: {
                layout.marginBottom = pixelValue;
                break;
            }
            case 3: {
                layout.marginLeft = pixelValue;
            }
        }
    }
}

