/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.ui;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectProjectDialog
extends TitleAreaDialog {
    private IProject selected;
    private final String desc;
    private final String title;
    private String defaultSel;
    private final ViewerFilter[] filters;
    private final boolean multi;
    private IProject[] multiSelected;

    public SelectProjectDialog(Shell parentShell, String title, String desc, boolean multi, ViewerFilter ... filters) {
        super(parentShell);
        this.title = title;
        this.desc = desc;
        this.multi = multi;
        this.filters = filters;
    }

    public void setDefaultSelection(String defaultSel) {
        this.defaultSel = defaultSel;
    }

    protected Control createDialogArea(Composite parent) {
        IProject project;
        this.setTitle(this.title);
        this.setMessage(this.desc, 1);
        Composite comp = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        GridLayoutFactory.fillDefaults().margins(20, 20).applyTo(comp);
        Object tv = this.multi ? CheckboxTableViewer.newCheckList((Composite)comp, (int)2816) : new TableViewer(comp, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 300).applyTo(tv.getControl());
        tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tv.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(new JavaUILabelProvider()));
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null || sel.isEmpty()) {
                    SelectProjectDialog.this.selected = null;
                } else {
                    SelectProjectDialog.this.selected = (IProject)sel.getFirstElement();
                }
                Button button = SelectProjectDialog.this.getButton(0);
                if (button != null) {
                    button.setEnabled(SelectProjectDialog.this.selected != null);
                }
            }
        });
        if (this.multi) {
            tv.addCheckStateListener(arg_0 -> this.lambda$0((TableViewer)tv, arg_0));
        }
        if (this.filters != null && this.filters.length > 0) {
            tv.setFilters(this.filters);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        tv.setInput((Object)root.getProjects());
        if (this.defaultSel != null && (project = root.getProject(this.defaultSel)) != null) {
            tv.setSelection((ISelection)new StructuredSelection((Object)project), true);
            this.selected = project;
        }
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(this.selected != null);
    }

    public IProject getResult() {
        return this.selected;
    }

    public IProject[] getMultiResult() {
        return this.multiSelected;
    }

    private /* synthetic */ void lambda$0(TableViewer tableViewer, CheckStateChangedEvent e) {
        this.multiSelected = (IProject[])Arrays.stream(((CheckboxTableViewer)tableViewer).getCheckedElements()).map(x -> (IProject)x).toArray(IProject[]::new);
    }
}

