/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.widgets.Shell;

public class CustomizableVariableSelectionDialog
extends StringVariableSelectionDialog {
    private final List<IStringVariable> extraVariables = new ArrayList<IStringVariable>();
    private final boolean initialized;
    private ImList<IStringVariable> elements;

    public CustomizableVariableSelectionDialog(Shell parent) {
        super(parent);
        if (this.elements == null) {
            this.elements = ImCollections.emptyList();
        }
        this.initialized = true;
    }

    public void setElements(Object[] elements) {
        this.elements = ImCollections.newList((Object[])((IStringVariable[])elements));
        if (this.initialized) {
            this.initElements();
        }
    }

    private void initElements() {
        HashMap variables = new HashMap();
        VariableUtils.add(variables, this.elements);
        VariableUtils.add(variables, this.extraVariables);
        super.setElements((Object[])variables.values().toArray(new IStringVariable[variables.size()]));
    }

    public int open() {
        this.initElements();
        return super.open();
    }

    public void setFilters(List<StringVariableSelectionDialog.VariableFilter> filters) {
        super.setFilters(filters.toArray(new StringVariableSelectionDialog.VariableFilter[filters.size()]));
    }

    public void setAdditionals(Collection<? extends IStringVariable> variables) {
        this.extraVariables.clear();
        this.extraVariables.addAll(variables);
    }

    public void addAdditional(IStringVariable variable) {
        this.extraVariables.add(variable);
    }
}

