/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import org.eclipse.statet.ecommons.waltable.coordinate.LRange;

public class StructuralDiff {
    private final DiffTypeEnum diffType;
    private final LRange beforePositionRange;
    private final LRange afterPositionRange;

    public StructuralDiff(DiffTypeEnum diffType, LRange beforePositionRange, LRange afterPositionRange) {
        if (diffType == null) {
            throw new NullPointerException("diffType");
        }
        if (beforePositionRange == null) {
            throw new NullPointerException("beforePositionRange");
        }
        if (afterPositionRange == null) {
            throw new NullPointerException("afterPositionRange");
        }
        this.diffType = diffType;
        this.beforePositionRange = beforePositionRange;
        this.afterPositionRange = afterPositionRange;
    }

    public DiffTypeEnum getDiffType() {
        return this.diffType;
    }

    public LRange getBeforePositionRange() {
        return this.beforePositionRange;
    }

    public LRange getAfterPositionRange() {
        return this.afterPositionRange;
    }

    public int hashCode() {
        return (this.diffType.hashCode() * 13 + this.beforePositionRange.hashCode()) * 14 + this.afterPositionRange.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StructuralDiff)) {
            return false;
        }
        StructuralDiff other = (StructuralDiff)obj;
        return this.diffType == other.diffType && this.beforePositionRange == other.beforePositionRange && this.afterPositionRange == other.afterPositionRange;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + (Object)((Object)this.diffType) + " (" + " before= " + this.beforePositionRange + ", " + " after= " + this.afterPositionRange + ")";
    }

    public static enum DiffTypeEnum {
        ADD,
        CHANGE,
        DELETE;

    }
}

