/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.core.model;

import org.eclipse.statet.dsl.core.model.DslElementName;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.yaml.core.model.YamlSourceElement;

@NonNullByDefault
public abstract class BasicYamlSourceElement
implements YamlSourceElement {
    protected static final ImList<YamlSourceElement> NO_CHILDREN = ImCollections.emptyList();
    protected DslElementName name;
    protected int occurrenceCount;
    protected TextRegion nameRegion;
    protected final DslAstNode astNode;

    protected BasicYamlSourceElement(DslAstNode astNode) {
        this.astNode = astNode;
    }

    public final String getModelTypeId() {
        return "Yaml";
    }

    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    @Override
    public DslElementName getElementName() {
        return this.name;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public TextRegion getSourceRange() {
        return this.astNode;
    }

    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)this.astNode;
        }
        return null;
    }

    public int hashCode() {
        return (this.getElementType() & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof BasicYamlSourceElement)) break block3;
                BasicYamlSourceElement other = (BasicYamlSourceElement)obj;
                if ((this.getElementType() & 0xFF0) == (this.getElementType() & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.getElementType() & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals((Object)other.getElementName())) break block2;
            }
            return false;
        }
        return true;
    }
}

