/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilterview;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.base.ui.contentfilter.FilterPage;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.swt.expandable.ExpandableRowsList;
import org.eclipse.statet.ecommons.ui.util.DNDUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataEditor;
import org.eclipse.statet.internal.r.ui.datafilter.FilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilterview.Messages;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableComposite;
import org.eclipse.statet.internal.r.ui.datafilterview.VariableContainer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.ui.dataeditor.DataViewDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableListener;
import org.eclipse.statet.r.ui.dataeditor.RDataTableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class RDataFilterPage
extends Page
implements FilterPage,
IShowInTarget {
    private static final String EXPAND_ALL_COMMAND_ID = "org.eclipse.ui.navigate.expandAll";
    private static final String COLLAPSE_ALL_COMMAND_ID = "org.eclipse.ui.navigate.collapseAll";
    private static final String COPY_EXPR_COMMAND_ID = "org.eclipse.statet.workbench.commands.CopyElementName";
    private Composite composite;
    private ExpandableRowsList scrollComposite;
    private Text filterText;
    private VariableContainer container;
    private FilterListener filterPostListener;
    private final RDataEditor editor;
    private RDataTableListener rDataTableListener;
    private HandlerContributionItem disableItem;

    public RDataFilterPage(RDataEditor editor) {
        this.editor = editor;
    }

    public RDataEditor getDataEditor() {
        return this.editor;
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"RDataFilterPage");
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IHandlerService handlerService = (IHandlerService)pageSite.getService(IHandlerService.class);
        IToolBarManager toolBarManager = pageSite.getActionBars().getToolBarManager();
        IMenuManager menuManager = pageSite.getActionBars().getMenuManager();
        AbstractHandler handler = new ExpandCollapseAllHandler(true);
        handlerService.activateHandler(EXPAND_ALL_COMMAND_ID, (IHandler)handler);
        handler = new ExpandCollapseAllHandler(false);
        handlerService.activateHandler(COLLAPSE_ALL_COMMAND_ID, (IHandler)handler);
        toolBarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)pageSite, null, COLLAPSE_ALL_COMMAND_ID, null, null, null, null, null, null, null, 8, null, false), (IHandler2)handler));
        handler = new DisableFiltersHandler();
        this.disableItem = new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)pageSite, null, "NO_COMMAND", null, SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/disable-filter"), null, null, Messages.Variables_DisableFilters_label, null, null, 32, null, false), (IHandler2)handler);
        toolBarManager.add((IContributionItem)this.disableItem);
        handler = new CopyFilterExpr();
        handlerService.activateHandler(COPY_EXPR_COMMAND_ID, (IHandler)handler);
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)pageSite, null, COPY_EXPR_COMMAND_ID, null, null, null, null, Messages.Variables_CopyExpr_label, null, null, 8, null, false)));
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.scrollComposite = new ExpandableRowsList(this.composite, 512);
        this.scrollComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.container = new VariableContainer((IServiceLocator)this.getSite(), this.scrollComposite);
        this.filterText = new Text(this.composite, 0x2000008);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.container.getFilterSet().addListener(new FilterListener(){

            @Override
            public void filterChanged() {
                if (!UIAccess.isOkToUse((Control)RDataFilterPage.this.filterText)) {
                    return;
                }
                RDataFilterPage.this.disableItem.update();
                String rExpression = RDataFilterPage.this.container.getFilterSet().getFilterRExpression();
                RDataFilterPage.this.filterText.setText(rExpression != null ? rExpression : "");
            }
        });
        this.disableItem.update();
        this.init();
    }

    protected void init() {
        this.rDataTableListener = new RDataTableListener(){

            @Override
            public void onInputChanged(@Nullable RDataTableInput input, @Nullable RDataTableContentDescription description, @Nullable DataViewDescription dataViewDescription) {
                if (description != null) {
                    RDataFilterPage.this.container.updateInput(description);
                }
            }
        };
        this.editor.getRDataTable().addTableListener(this.rDataTableListener);
        this.filterPostListener = new FilterListener(){

            @Override
            public void filterChanged() {
                RDataTableViewer rDataTable = RDataFilterPage.this.editor.getRDataTable();
                if (rDataTable == null || rDataTable.isDisposed()) {
                    return;
                }
                if (rDataTable.getDescription() == RDataFilterPage.this.container.getDescription()) {
                    FilterSet filterSet = RDataFilterPage.this.container.getFilterSet();
                    if (filterSet.getEnabled()) {
                        rDataTable.setFilter(RDataFilterPage.this.container.getFilterSet().getFilterRExpression());
                    } else {
                        rDataTable.setFilter(null);
                    }
                }
            }
        };
        this.container.getFilterSet().addPostListener(this.filterPostListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        this.scrollComposite.getContent().setFocus();
    }

    public boolean show(ShowInContext context) {
        return this.editor.getEditorInput() == context.getInput();
    }

    public void dispose() {
        super.dispose();
        RDataTableViewer rDataTable = this.editor.getRDataTable();
        if (rDataTable != null && rDataTable.isDisposed()) {
            rDataTable = null;
        }
        if (this.rDataTableListener != null && rDataTable != null) {
            rDataTable.removeTableListener(this.rDataTableListener);
            this.rDataTableListener = null;
        }
        if (this.filterPostListener != null) {
            this.container.getFilterSet().removePostListener(this.filterPostListener);
            this.filterPostListener = null;
        }
        if (rDataTable != null) {
            rDataTable.setFilter(null);
        }
        this.container.dispose();
    }

    private class CopyFilterExpr
    extends AbstractHandler {
        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            FilterSet filterSet = RDataFilterPage.this.container.getFilterSet();
            String rExpression = filterSet.getFilterRExpression(null, 0);
            if (rExpression != null) {
                Clipboard clipboard = new Clipboard(RDataFilterPage.this.composite.getDisplay());
                try {
                    Boolean bl = DNDUtils.setContent((Clipboard)clipboard, (Object[])new Object[]{rExpression}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
                    return bl;
                }
                finally {
                    clipboard.dispose();
                }
            }
            return null;
        }
    }

    private class DisableFiltersHandler
    extends AbstractHandler
    implements IElementUpdater {
        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
            try {
                FilterSet filterSet = RDataFilterPage.this.container.getFilterSet();
                element.setChecked(!filterSet.getEnabled());
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
            FilterSet filterSet;
            filterSet.setEnabled(!(filterSet = RDataFilterPage.this.container.getFilterSet()).getEnabled());
            return null;
        }
    }

    private class ExpandCollapseAllHandler
    extends AbstractHandler {
        private final boolean expanded;

        public ExpandCollapseAllHandler(boolean expanded) {
            this.expanded = expanded;
        }

        public @Nullable Object execute(@Nullable ExecutionEvent event) throws ExecutionException {
            RDataFilterPage.this.scrollComposite.setRedraw(false);
            RDataFilterPage.this.scrollComposite.setDelayedReflow(true);
            try {
                List<VariableComposite> variables = RDataFilterPage.this.container.getVariables();
                for (VariableComposite variable : variables) {
                    variable.setExpanded(this.expanded);
                }
            }
            finally {
                RDataFilterPage.this.scrollComposite.setDelayedReflow(false);
                RDataFilterPage.this.scrollComposite.reflow(true);
                RDataFilterPage.this.scrollComposite.setRedraw(true);
            }
            return null;
        }
    }
}

