/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.model.rpkg.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.Name;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.NodeType;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.RPkgSpecAstNode;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecAddition;
import org.eclipse.statet.internal.r.core.model.rpkg.ast.SpecList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public class SpecItem
extends RPkgSpecAstNode {
    private Name nameChild;
    private @Nullable SpecAddition constraintChild;

    public SpecItem(SpecList parent, int startOffset, int endOffset) {
        super((AstNode)parent);
        this.doSetStartEndOffset(startOffset, endOffset);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SPEC_ITEM;
    }

    public RPkgSpecAstNode getNameChild() {
        return this.nameChild;
    }

    public @Nullable RPkgSpecAstNode getAdditionChild() {
        return this.constraintChild;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getChildCount() {
        return this.constraintChild != null ? 2 : 1;
    }

    @Override
    public RPkgSpecAstNode getChild(int index) {
        switch (index) {
            case 0: {
                return this.nameChild;
            }
            case 1: {
                if (this.constraintChild == null) break;
                return this.constraintChild;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public int getChildIndex(AstNode child) {
        if (this.nameChild == child) {
            return 0;
        }
        if (this.constraintChild == child) {
            return 1;
        }
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        this.nameChild.accept(visitor);
        if (this.constraintChild != null) {
            this.constraintChild.accept(visitor);
        }
    }

    void setNameChild(Name child) {
        this.nameChild = child;
        this.doSetStatusSeverityOfChild(child.getStatusCode());
    }

    void setConstraintChild(SpecAddition child) {
        this.constraintChild = child;
        this.doSetEndOffset(child.getEndOffset());
        this.doAddStatusSeverityOfChild(child.getStatusCode());
    }
}

