/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.nico.ui.LoadHistoryPage;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUIMessages;
import org.eclipse.ui.statushandlers.StatusManager;

public class LoadHistoryWizard
extends Wizard {
    static final String STORE_SECTION = "tools/LoadSaveHistoryWizard";
    private final ToolProcess fProcess;
    private LoadHistoryPage fPage;

    public LoadHistoryWizard(ToolProcess process) {
        this.fProcess = process;
        this.setDialogSettings(DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)STORE_SECTION));
        this.setWindowTitle(NicoUIMessages.LoadHistory_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fPage = new LoadHistoryPage(this.fProcess);
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.saveSettings();
        try {
            final History history = this.fProcess.getHistory();
            final Object file = this.fPage.getFile();
            final Charset charset = this.fPage.getCharset();
            assert (history != null);
            assert (file != null);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    Status status = history.load(file, charset, false, EStatusUtils.convert((IProgressMonitor)monitor));
                    if (status.getSeverity() == 4) {
                        throw new InvocationTargetException(new CoreException(EStatusUtils.convert((Status)status)));
                    }
                }
            });
            return true;
        }
        catch (OperationCanceledException e) {
            return false;
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getTargetException()) instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)cause).getStatus(), 3);
                return false;
            }
            NicoUIPlugin.logError(100, "Error of unexpected type occured, when performing load history.", e);
            return false;
        }
    }
}

