/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.workbench.ContainerSelectionComposite;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.ltk.ui.wizards.LTKWizardsMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class NewElementWizardPage
extends WizardPage {
    protected IStructuredSelection resourceSelection;

    public NewElementWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this.resourceSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newContentGrid());
        this.createContents(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected abstract void createContents(Composite var1);

    protected void validatePage() {
        this.updateStatus((IStatus)new StatusInfo());
    }

    protected void updateStatus(IStatus status) {
        if (status != null) {
            this.setPageComplete(!status.matches(4));
        } else {
            this.setPageComplete(false);
            status = new StatusInfo();
        }
        Control control = this.getControl();
        if (control != null && control.isVisible()) {
            StatusInfo.applyToStatusLine((DialogPage)this, (IStatus)status);
        }
    }

    protected static class ProjectNatureContainerFilter
    extends ContainerSelectionComposite.ContainerFilter {
        private final ImSet<String> natureIds;

        public ProjectNatureContainerFilter(ImSet<String> natureIds) {
            this.natureIds = natureIds;
        }

        public ProjectNatureContainerFilter(String natureId) {
            this.natureIds = ImCollections.newSet((Object)natureId);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(IContainer container) {
            try {
                String natureId;
                IProject project = container.getProject();
                Iterator iterator = this.natureIds.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while (project.hasNature(natureId = (String)iterator.next()));
                return false;
            }
            catch (CoreException e) {
                return false;
            }
        }
    }

    public class ResourceGroup
    implements Listener {
        private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
        private static final String DIALOGSETTING_ENABLEFILTER = "org.eclipse.statet.base.NewElementWizard.ContainerFilter";
        private final String resourceNameDefaultSuffix;
        private final ContainerSelectionComposite.ContainerFilter containerFilter;
        private ContainerSelectionComposite containerGroup;
        private Text resourceNameControl;
        private IPath containerFullPath;
        private String resourceName;
        private boolean resourceNameEdited;

        public ResourceGroup(String defaultResourceNameExtension, ContainerSelectionComposite.ContainerFilter containerFilter) {
            this.resourceNameDefaultSuffix = defaultResourceNameExtension;
            this.containerFilter = containerFilter;
        }

        public void createGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            this.containerGroup = new ContainerSelectionComposite(composite, true, false, null, 250);
            this.containerGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.containerGroup.setListener((Listener)this);
            boolean enableFilter = true;
            if (NewElementWizardPage.this.getDialogSettings().get(DIALOGSETTING_ENABLEFILTER) != null) {
                enableFilter = NewElementWizardPage.this.getDialogSettings().getBoolean(DIALOGSETTING_ENABLEFILTER);
            }
            this.containerGroup.setToggleFilter(this.containerFilter, enableFilter);
            Label label = new Label(composite, 16384);
            label.setText(this.getNewFileLabel());
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            Text input = new Text(composite, 2052);
            input.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.resourceNameControl = input;
            this.resourceNameControl.addListener(24, (Listener)this);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.initFields();
        }

        protected String getNewFileLabel() {
            return LTKWizardsMessages.ResourceGroup_NewFile_label;
        }

        protected void initFields() {
            IPath path = null;
            if (this.containerFullPath != null) {
                path = this.containerFullPath;
            } else {
                Iterator it = NewElementWizardPage.this.resourceSelection.iterator();
                if (it.hasNext()) {
                    Object object = it.next();
                    IResource selectedResource = null;
                    if (object instanceof IResource) {
                        selectedResource = (IResource)object;
                    } else if (object instanceof IAdaptable) {
                        selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                    }
                    if (selectedResource != null) {
                        if (selectedResource.getType() == 1) {
                            selectedResource = selectedResource.getParent();
                        }
                        if (selectedResource.isAccessible()) {
                            path = selectedResource.getFullPath();
                        }
                    }
                }
            }
            if (path != null) {
                this.containerGroup.selectContainer(path);
            }
            if (this.resourceName != null) {
                this.resourceNameControl.setText(this.resourceName);
            }
        }

        public void handleEvent(Event event) {
            this.containerFullPath = this.containerGroup.getContainerFullPath();
            String name = this.resourceNameControl.getText();
            if (!this.resourceNameEdited && event.widget == this.resourceNameControl && name.length() > 0 && !name.equals(this.resourceName)) {
                this.resourceNameEdited = true;
            }
            this.resourceName = name;
            NewElementWizardPage.this.validatePage();
        }

        public IPath getContainerFullPath() {
            return this.containerFullPath;
        }

        public String getResourceName() {
            Object name = this.resourceName;
            if (!((String)name).endsWith(this.resourceNameDefaultSuffix)) {
                name = (String)name + this.resourceNameDefaultSuffix;
            }
            return name;
        }

        public void setFocus() {
            this.resourceNameControl.setFocus();
        }

        public IStatus validate() {
            if (this.containerGroup == null) {
                return null;
            }
            IStatus containerSelectionStatus = ContainerSelectionComposite.validate((IPath)this.containerFullPath);
            if (containerSelectionStatus.matches(4)) {
                return containerSelectionStatus;
            }
            IStatus resourceNameStatus = this.validateResourceName(this.resourceName);
            if (resourceNameStatus == null || resourceNameStatus.matches(4)) {
                return resourceNameStatus;
            }
            IPath path = this.containerGroup.getContainerFullPath().append(this.getResourceName());
            return this.validateFullResourcePath(path);
        }

        protected IStatus validateResourceName(String resourceName) {
            if (resourceName == null || resourceName.trim().isEmpty()) {
                if (this.resourceNameEdited) {
                    return new StatusInfo(4, NLS.bind((String)LTKWizardsMessages.ResourceGroup_error_EmptyName, (Object)SharedMessages.Resources_File));
                }
                return null;
            }
            if (!new Path("").isValidSegment(resourceName)) {
                return new StatusInfo(4, NLS.bind((String)LTKWizardsMessages.ResourceGroup_error_InvalidFilename, (Object)resourceName));
            }
            return new StatusInfo();
        }

        protected IStatus validateFullResourcePath(IPath resourcePath) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus result = workspace.validatePath(resourcePath.toString(), 1);
            if (!result.isOK()) {
                return result;
            }
            if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                return new StatusInfo(4, LTKWizardsMessages.ResourceGroup_error_ResourceExists);
            }
            return new StatusInfo();
        }

        public void saveSettings() {
            NewElementWizardPage.this.getDialogSettings().put(DIALOGSETTING_ENABLEFILTER, this.containerGroup.getToggleFilterSetting());
        }
    }
}

