/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.ui.sourceediting.CommandAccess;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistProcessorCommandExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

@NonNullByDefault
public class QuickAssistProcessor
implements IQuickAssistProcessor,
QuickAssistProcessorCommandExtension {
    private final SourceEditor editor;
    private @Nullable String errorMessage;

    public QuickAssistProcessor(SourceEditor editor) {
        this.editor = (SourceEditor)ObjectUtils.nonNullAssert((Object)editor);
    }

    public final SourceEditor getEditor() {
        return this.editor;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return false;
    }

    public boolean canFix(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return false;
        }
        String type = annotation.getType();
        return type.equals("org.eclipse.ui.workbench.texteditor.spelling");
    }

    protected @Nullable AssistInvocationContext createContext(IQuickAssistInvocationContext invocationContext, DocContentSections documentContentInfo, String contentType, IProgressMonitor monitor) {
        return new AssistInvocationContext(this.getEditor(), invocationContext.getOffset(), documentContentInfo, contentType, 2, monitor);
    }

    public @NonNull ICompletionProposal @Nullable [] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        AssistProposalCollector proposals;
        AssistInvocationContext context;
        SubMonitor m;
        block7: {
            block6: {
                this.errorMessage = null;
                m = SubMonitor.convert(null, (int)14);
                DocContentSections documentContentInfo = this.editor.getDocumentContentInfo();
                String contentType = TextUtils.getContentType((IDocument)this.editor.getViewer().getDocument(), (DocContentSections)documentContentInfo, (int)invocationContext.getOffset(), (invocationContext.getLength() == 0 ? 1 : 0) != 0);
                context = this.createContext(invocationContext, documentContentInfo, contentType, (IProgressMonitor)m.newChild(3));
                if (context != null) break block6;
                return null;
            }
            proposals = new AssistProposalCollector();
            IAnnotationModel model = context.getSourceViewer().getAnnotationModel();
            if (model != null) {
                this.addAnnotationProposals(context, proposals, model);
                m.worked(5);
            }
            m.setWorkRemaining(6);
            if (context.getModelInfo() != null) {
                this.addModelAssistProposals(context, proposals, (IProgressMonitor)m.newChild(5));
            }
            if (proposals.getCount() != 0) break block7;
            return null;
        }
        try {
            m.setWorkRemaining(1);
            return this.filterAndSortCompletionProposals(proposals, context, (IProgressMonitor)m.newChild(1));
        }
        catch (BadLocationException | BadPartitioningException e) {
            return null;
        }
    }

    protected @NonNull AssistProposal[] filterAndSortCompletionProposals(AssistProposalCollector proposals, AssistInvocationContext context, IProgressMonitor monitor) {
        AssistProposal[] array = proposals.toArray();
        if (array.length > 1) {
            Arrays.sort(array, ContentAssistProcessor.PROPOSAL_COMPARATOR);
        }
        return array;
    }

    protected boolean isMatchingPosition(@Nullable Position pos, int offset) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void addAnnotationProposals(IQuickAssistInvocationContext invocationContext, AssistProposalCollector proposals, IAnnotationModel model) {
        int offset = invocationContext.getOffset();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            SpellingProblem problem;
            ICompletionProposal[] annotationProposals;
            String type;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted() || !(type = annotation.getType()).equals("org.eclipse.ui.workbench.texteditor.spelling") || !this.isMatchingPosition(model.getPosition(annotation), offset) || !(annotation instanceof SpellingAnnotation) || (annotationProposals = (problem = ((SpellingAnnotation)annotation).getSpellingProblem()).getProposals(invocationContext)) == null || annotationProposals.length <= 0) continue;
            int i = 0;
            while (i < annotationProposals.length) {
                proposals.add(new SpellingProposal(annotationProposals[i]));
                ++i;
            }
        }
    }

    protected void addModelAssistProposals(AssistInvocationContext invocationContext, AssistProposalCollector proposals, IProgressMonitor monitor) {
    }

    public @Nullable String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public @Nullable AssistProposal findQuickAssist(IQuickAssistInvocationContext invocationContext, String commandId) {
        ICompletionProposal[] proposals = this.computeQuickAssistProposals(invocationContext);
        if (proposals == null) {
            return null;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal instanceof AssistProposal && proposal instanceof CommandAccess && ((CommandAccess)proposal).getCommandId().equals(commandId)) {
                return (AssistProposal)proposal;
            }
            ++n2;
        }
        return null;
    }

    private static class SpellingProposal
    implements AssistProposal {
        private final ICompletionProposal proposal;

        public SpellingProposal(ICompletionProposal proposal) {
            this.proposal = proposal;
        }

        @Override
        public int getRelevance() {
            try {
                Method method = this.proposal.getClass().getMethod("getRelevance", new Class[0]);
                Object value = method.invoke((Object)this.proposal, new Object[0]);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        @Override
        public String getSortingString() {
            return "";
        }

        public String getDisplayString() {
            return this.proposal.getDisplayString();
        }

        public Image getImage() {
            return this.proposal.getImage();
        }

        @Override
        public void selected(ITextViewer viewer, boolean smartToggle) {
            if (this.proposal instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)this.proposal).selected(viewer, smartToggle);
            }
        }

        @Override
        public void unselected(ITextViewer viewer) {
            if (this.proposal instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)this.proposal).unselected(viewer);
            }
        }

        public @Nullable String getAdditionalProposalInfo() {
            return this.proposal.getAdditionalProposalInfo();
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            if (this.proposal instanceof ICompletionProposalExtension2) {
                return ((ICompletionProposalExtension2)this.proposal).validate(document, offset, event);
            }
            return false;
        }

        @Override
        public void apply(IDocument document) {
            this.proposal.apply(document);
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            if (this.proposal instanceof ICompletionProposalExtension2) {
                ((ICompletionProposalExtension2)this.proposal).apply(viewer, trigger, stateMask, offset);
            } else {
                this.proposal.apply(viewer.getDocument());
            }
        }

        public @Nullable Point getSelection(IDocument document) {
            return this.proposal.getSelection(document);
        }

        public @Nullable IContextInformation getContextInformation() {
            return this.proposal.getContextInformation();
        }
    }
}

