/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.graphic.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class ColorDef {
    public static final String RGB_DEF_TYPE = "RGB";
    public static final String HSV_DEF_TYPE = "HSV";
    protected final int rgb;

    protected static final int checkRGB(int red, int green, int blue) {
        if ((red & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("red");
        }
        if ((green & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("green");
        }
        if ((blue & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException("blue");
        }
        return red | green << 8 | blue << 16;
    }

    protected static final float round1(float v) {
        return (float)Math.round(v * 1000.0f) / 1000.0f;
    }

    protected ColorDef(int rgb) {
        this.rgb = rgb;
    }

    protected ColorDef(ColorDef def) {
        this.rgb = def.rgb;
    }

    public abstract String getType();

    public @Nullable String getName() {
        return null;
    }

    public final int getRed() {
        return this.rgb & 0xFF;
    }

    public final int getGreen() {
        return this.rgb >>> 8 & 0xFF;
    }

    public final int getBlue() {
        return this.rgb >>> 16 & 0xFF;
    }

    public final int getRGB() {
        return this.rgb;
    }

    public final String getRGBHexString() {
        byte[] latin1 = new byte[6];
        int code = (this.rgb & 0xFF) << 16 | this.rgb & 0xFF00 | (this.rgb & 0xFF0000) >>> 16;
        int i = 6;
        do {
            --i;
            latin1[i] = switch (code & 0xF) {
                case 0 -> 48;
                case 1 -> 49;
                case 2 -> 50;
                case 3 -> 51;
                case 4 -> 52;
                case 5 -> 53;
                case 6 -> 54;
                case 7 -> 55;
                case 8 -> 56;
                case 9 -> 57;
                case 10 -> 65;
                case 11 -> 66;
                case 12 -> 67;
                case 13 -> 68;
                case 14 -> 69;
                case 15 -> 70;
                default -> 0;
            };
            code >>>= 4;
        } while (i > 0);
        return new String(latin1, 0, 0, latin1.length);
    }

    public final String getRGBDecString() {
        StringBuilder sb = new StringBuilder(11);
        sb.append(this.getRed());
        sb.append(',');
        sb.append(this.getGreen());
        sb.append(',');
        sb.append(this.getBlue());
        return sb.toString();
    }

    public int hashCode() {
        return this.rgb;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof ColorDef)) break block3;
                ColorDef other = (ColorDef)obj;
                if (this.getType() == other.getType() && this.rgb == other.rgb) break block2;
            }
            return false;
        }
        return true;
    }

    public final boolean equalsRGB(@Nullable ColorDef other) {
        return other != null && this.rgb == other.rgb;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append('#');
        sb.append(this.getRGBHexString());
    }
}

