/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.persistence;

import java.util.Map;
import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.core.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.persistence.ColorPersistor;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class StylePersistor {
    public static final String STYLE_PERSISTENCE_PREFIX = "style";
    public static final String BLUE_COLOR_PREFIX = "blue";
    public static final String GREEN_COLOR_PREFIX = "green";
    public static final String RED_COLOR_PREFIX = "red";
    public static final String V_ALIGNMENT_PREFIX = "verticalAlignment";
    public static final String H_ALIGNMENT_PREFIX = "horizontalAlignment";
    public static final String BG_COLOR_PREFIX = "bg";
    public static final String FG_COLOR_PREFIX = "fg";
    public static final String FONT_PREFIX = "font";
    public static final String BORDER_PREFIX = "border";

    public static void saveStyle(String prefix, Map<String, String> properties, Style style) {
        prefix = (String)prefix + ".style";
        StylePersistor.saveColor((String)prefix + ".bg", properties, style.getAttributeValue(CellStyling.BACKGROUND_COLOR));
        StylePersistor.saveColor((String)prefix + ".fg", properties, style.getAttributeValue(CellStyling.FOREGROUND_COLOR));
        StylePersistor.saveHAlign((String)prefix, properties, style.getAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT));
        StylePersistor.saveVAlign((String)prefix, properties, style.getAttributeValue(CellStyling.VERTICAL_ALIGNMENT));
        StylePersistor.saveFont((String)prefix, properties, style.getAttributeValue(CellStyling.FONT));
        StylePersistor.saveBorder((String)prefix, properties, style.getAttributeValue(CellStyling.BORDER_STYLE));
    }

    protected static void saveVAlign(String prefix, Map<String, String> properties, VerticalAlignment vAlign) {
        if (vAlign == null) {
            return;
        }
        properties.put(prefix + ".verticalAlignment", vAlign.name());
    }

    protected static void saveHAlign(String prefix, Map<String, String> properties, HorizontalAlignment hAlign) {
        if (hAlign == null) {
            return;
        }
        properties.put(prefix + ".horizontalAlignment", hAlign.name());
    }

    protected static void saveBorder(String prefix, Map<String, String> properties, BorderStyle borderStyle) {
        if (borderStyle == null) {
            return;
        }
        properties.put(prefix + ".border", String.valueOf(borderStyle.toString()));
    }

    protected static void saveFont(String prefix, Map<String, String> properties, Font font) {
        if (font == null) {
            return;
        }
        properties.put(prefix + ".font", String.valueOf(font.getFontData()[0].toString()));
    }

    protected static void saveColor(String prefix, Map<String, String> properties, Color color) {
        if (color == null) {
            return;
        }
        ColorPersistor.saveColor(prefix, properties, color);
    }

    public static BasicStyle loadStyle(String prefix, Map<String, String> properties) {
        String borderPrefix;
        BorderStyle borderStyle;
        String fontPrefix;
        Font font;
        String vAlignPrefix;
        VerticalAlignment vAlign;
        String hAlignPrefix;
        HorizontalAlignment hAlign;
        String fgColorPrefix;
        Color fgColor;
        BasicStyle style = new BasicStyle();
        String bgColorPrefix = (String)(prefix = (String)prefix + ".style") + ".bg";
        Color bgColor = StylePersistor.loadColor(bgColorPrefix, properties);
        if (bgColor != null) {
            style.setAttributeValue(CellStyling.BACKGROUND_COLOR, bgColor);
        }
        if ((fgColor = StylePersistor.loadColor(fgColorPrefix = (String)prefix + ".fg", properties)) != null) {
            style.setAttributeValue(CellStyling.FOREGROUND_COLOR, fgColor);
        }
        if ((hAlign = StylePersistor.loadHAlignment(hAlignPrefix = (String)prefix + ".horizontalAlignment", properties)) != null) {
            style.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, hAlign);
        }
        if ((vAlign = StylePersistor.loadVAlignment(vAlignPrefix = (String)prefix + ".verticalAlignment", properties)) != null) {
            style.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, vAlign);
        }
        if ((font = StylePersistor.loadFont(fontPrefix = (String)prefix + ".font", properties)) != null) {
            style.setAttributeValue(CellStyling.FONT, font);
        }
        if ((borderStyle = StylePersistor.loadBorderStyle(borderPrefix = (String)prefix + ".border", properties)) != null) {
            style.setAttributeValue(CellStyling.BORDER_STYLE, borderStyle);
        }
        return style;
    }

    private static BorderStyle loadBorderStyle(String borderPrefix, Map<String, String> properties) {
        String borderStyle = properties.get(borderPrefix);
        if (borderStyle != null) {
            return new BorderStyle(borderStyle);
        }
        return null;
    }

    private static Font loadFont(String fontPrefix, Map<String, String> properties) {
        String fontdata = properties.get(fontPrefix);
        if (fontdata != null) {
            return GUIHelper.getFont(new FontData(fontdata));
        }
        return null;
    }

    private static HorizontalAlignment loadHAlignment(String hAlignPrefix, Map<String, String> properties) {
        String enumName = properties.get(hAlignPrefix);
        if (enumName != null) {
            return HorizontalAlignment.valueOf(enumName);
        }
        return null;
    }

    private static VerticalAlignment loadVAlignment(String vAlignPrefix, Map<String, String> properties) {
        String enumName = properties.get(vAlignPrefix);
        if (enumName != null) {
            return VerticalAlignment.valueOf(enumName);
        }
        return null;
    }

    protected static Color loadColor(String prefix, Map<String, String> properties) {
        return ColorPersistor.loadColor(prefix, properties);
    }
}

