/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.core.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.TransformLayer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class DimensionallyDependentLayer
extends TransformLayer<ForwardLayerDim<? extends DimensionallyDependentLayer>> {
    private Layer horizontalLayerDependency = (Layer)ObjectUtils.nonNullLateInit();
    private Layer verticalLayerDependency = (Layer)ObjectUtils.nonNullLateInit();

    public DimensionallyDependentLayer(Layer baseLayer, Layer horizontalLayerDependency, Layer verticalLayerDependency, @Nullable LayerPainter layerPainter) {
        super(baseLayer, layerPainter);
        this.horizontalLayerDependency = horizontalLayerDependency;
        this.verticalLayerDependency = verticalLayerDependency;
        this.init();
    }

    public DimensionallyDependentLayer(Layer baseLayer, Layer horizontalLayerDependency, Layer verticalLayerDependency) {
        this(baseLayer, horizontalLayerDependency, verticalLayerDependency, null);
    }

    protected DimensionallyDependentLayer(Layer baseLayer, @Nullable LayerPainter layerPainter) {
        super(baseLayer, layerPainter);
    }

    @Override
    protected void init() {
        if (this.horizontalLayerDependency == null || this.verticalLayerDependency == null) {
            return;
        }
        super.init();
    }

    @Override
    protected ForwardLayerDim<? extends DimensionallyDependentLayer> createDim(Orientation orientation) {
        Layer dependency = this.getLayerDependency(orientation);
        if (dependency == this.getBaseLayer()) {
            return new ForwardLayerDim<DimensionallyDependentLayer>(this, dependency.getDim(orientation));
        }
        return new Dim(this, dependency.getDim(orientation));
    }

    protected void setHorizontalLayerDependency(Layer horizontalLayerDependency) {
        this.horizontalLayerDependency = horizontalLayerDependency;
        this.init();
    }

    protected void setVerticalLayerDependency(Layer verticalLayerDependency) {
        this.verticalLayerDependency = verticalLayerDependency;
        this.init();
    }

    public Layer getHorizontalLayerDependency() {
        return this.horizontalLayerDependency;
    }

    public Layer getVerticalLayerDependency() {
        return this.verticalLayerDependency;
    }

    public Layer getLayerDependency(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.horizontalLayerDependency : this.verticalLayerDependency;
    }

    public Layer getBaseLayer() {
        return this.getUnderlyingLayer();
    }

    @Override
    public boolean doCommand(LayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        if (this.getBaseLayer() != this.horizontalLayerDependency && this.horizontalLayerDependency.doCommand(command)) {
            return true;
        }
        return this.getBaseLayer() != this.verticalLayerDependency && this.verticalLayerDependency.doCommand(command);
    }

    protected static class Dim
    extends ForwardLayerDim<DimensionallyDependentLayer> {
        public Dim(DimensionallyDependentLayer layer, LayerDim underlyingDim) {
            super(layer, underlyingDim);
        }

        protected LayerDim getBaseDim() {
            return ((DimensionallyDependentLayer)this.layer).getBaseLayer().getDim(this.orientation);
        }

        @Override
        public long localToUnderlyingPosition(long refPosition, long position) {
            long id = this.underlyingDim.getPositionId(refPosition, position);
            long underlyingPosition = this.getBaseDim().getPositionById(id);
            if (underlyingPosition == Long.MIN_VALUE) {
                throw new PositionOutOfBoundsException(position, this.getOrientation());
            }
            return underlyingPosition;
        }

        @Override
        public long underlyingToLocalPosition(LayerDim sourceUnderlyingDim, long underlyingPosition) {
            if (sourceUnderlyingDim != this.getBaseDim()) {
                throw new IllegalArgumentException("underlyingLayer");
            }
            return this.doUnderlyingToLocalPosition(underlyingPosition);
        }

        @Override
        public List<LRange> underlyingToLocalPositions(LayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
            if (sourceUnderlyingDim != this.getBaseDim()) {
                throw new IllegalArgumentException("underlyingLayer");
            }
            ArrayList<LRange> localPositions = new ArrayList<LRange>(underlyingPositions.size());
            for (LRange underlyingPositionRange : underlyingPositions) {
                long last;
                if (underlyingPositionRange.start == underlyingPositionRange.end) {
                    long position = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
                    localPositions.add(new LRange(position, position));
                    continue;
                }
                long first = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
                if (first > (last = this.doUnderlyingToLocalPosition(underlyingPositionRange.end - 1L))) continue;
                localPositions.add(new LRange(first, last + 1L));
            }
            return localPositions;
        }

        protected long doUnderlyingToLocalPosition(long underlyingPosition) {
            long id = this.getBaseDim().getPositionId(underlyingPosition, underlyingPosition);
            long position = this.underlyingDim.getPositionById(id);
            if (underlyingPosition == Long.MIN_VALUE) {
                throw new PositionOutOfBoundsException("underlyingPosition", underlyingPosition, this.getOrientation());
            }
            return position;
        }

        @Override
        public ImList<LayerDim> getUnderlyingDimsByPosition(long position) {
            return ImCollections.newList((Object)this.getBaseDim());
        }
    }
}

