/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class TextUtils {
    public static Object getLockObject(Object o) {
        Object lockObject = o instanceof ISynchronizable ? ((ISynchronizable)o).getLockObject() : null;
        return lockObject != null ? lockObject : o;
    }

    public static String getContentType(IDocument document, String partitioning, int offset, boolean preferOpenPartition) throws BadPartitioningException, BadLocationException {
        return ((IDocumentExtension3)document).getContentType(partitioning, offset, preferOpenPartition);
    }

    public static ITypedRegion getPartition(IDocument document, String partitioning, int offset, boolean preferOpenPartition) throws BadPartitioningException, BadLocationException {
        return ((IDocumentExtension3)document).getPartition(partitioning, offset, preferOpenPartition);
    }

    public static String getContentType(IDocument document, DocContentSections contentInfo, int offset, boolean preferOpenPartition) throws BadPartitioningException, BadLocationException {
        return ((IDocumentExtension3)document).getContentType(contentInfo.getPartitioning(), offset, preferOpenPartition);
    }

    public static ITypedRegion getPartition(IDocument document, DocContentSections contentInfo, int offset, boolean preferOpenPartition) throws BadPartitioningException, BadLocationException {
        return ((IDocumentExtension3)document).getPartition(contentInfo.getPartitioning(), offset, preferOpenPartition);
    }

    public static final boolean isCommonWord2Part(int cp) {
        return switch (cp) {
            case 43, 45, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 95, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122 -> true;
            case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 47, 58, 59, 60, 61, 62, 63, 91, 92, 93, 94, 96, 123, 124, 125, 126 -> false;
            default -> {
                switch (Character.getType(cp)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 20: 
                    case 23: 
                    case 27: {
                        yield true;
                    }
                }
                yield false;
            }
        };
    }

    public static final int findCommonWord2Start(IDocument document, int offset, int bound) throws BadLocationException {
        while (--offset >= bound && TextUtils.isCommonWord2Part(document.getChar(offset))) {
        }
        return offset + 1;
    }

    public static final int findCommonWord2End(IDocument document, int offset, int bound) throws BadLocationException {
        while (++offset < bound && TextUtils.isCommonWord2Part(document.getChar(offset))) {
        }
        return offset;
    }
}

