/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.SqlException;

class CloseFilterInputStream
extends FilterInputStream {
    private static final String ALREADY_CLOSED_ERR_MESSAGE = SqlException.getMessageUtil().getTextMessage("J104", new Object[0]);
    private boolean closed = false;

    public CloseFilterInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            throw new IOException(ALREADY_CLOSED_ERR_MESSAGE);
        }
        return super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

