/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.sorters;

import java.util.Set;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreePathViewerSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceContentProvider;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSorterService;

public class NonFinalCommonViewerSorter
extends TreePathViewerSorter {
    private static final int LEFT_UNDERSTANDS = 1;
    private static final int RIGHT_UNDERSTANDS = 2;
    private static final int BOTH_UNDERSTAND = 3;
    private INavigatorContentService contentService;
    private INavigatorSorterService sorterService;

    public void setContentService(INavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.sorterService = this.contentService.getSorterService();
    }

    public int category(Object element) {
        if (this.contentService == null) {
            return 0;
        }
        INavigatorContentDescriptor source = this.getSource(element);
        return source != null ? source.getSequenceNumber() : 3;
    }

    private void logMissingExtension(Object parent, Object object) {
        NavigatorPlugin.logError((int)0, (String)NLS.bind((String)CommonNavigatorMessages.CommonViewerSorter_NoContentExtensionForObject, (Object)(object != null ? object.toString() : "<null>"), (Object)(parent != null ? parent.toString() : "<null>")), null);
    }

    public int compare(Viewer viewer, TreePath parentPath, Object e1, Object e2) {
        if (this.contentService == null) {
            return -1;
        }
        INavigatorContentDescriptor sourceOfLvalue = this.getSource(e1);
        INavigatorContentDescriptor sourceOfRvalue = this.getSource(e2);
        Object parent = parentPath == null ? viewer.getInput() : parentPath.getLastSegment();
        if (sourceOfLvalue == null) {
            this.logMissingExtension(parent, e1);
            return -1;
        }
        if (sourceOfRvalue == null) {
            this.logMissingExtension(parent, e2);
            return -1;
        }
        ViewerSorter sorter = null;
        if (sourceOfLvalue == sourceOfRvalue) {
            sorter = this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2);
        } else {
            boolean[] flags = new boolean[]{sourceOfLvalue.isTriggerPoint(e1), sourceOfLvalue.isTriggerPoint(e2), sourceOfRvalue.isTriggerPoint(e1), sourceOfRvalue.isTriggerPoint(e2)};
            int whoknows = 0;
            whoknows |= flags[0] & flags[1] ? 1 : 0;
            switch (whoknows |= flags[2] & flags[3] ? 2 : 0) {
                case 3: {
                    sorter = sourceOfLvalue.getSequenceNumber() < sourceOfRvalue.getSequenceNumber() ? this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2) : this.sorterService.findSorter(sourceOfRvalue, parent, e1, e2);
                    break;
                }
                case 1: {
                    sorter = this.sorterService.findSorter(sourceOfLvalue, parent, e1, e2);
                    break;
                }
                case 2: {
                    sorter = this.sorterService.findSorter(sourceOfRvalue, parent, e1, e2);
                }
            }
        }
        if (sorter != null) {
            return sorter.compare(viewer, e1, e2);
        }
        int categoryDelta = this.category(e1) - this.category(e2);
        if (categoryDelta == 0) {
            return super.compare(viewer, e1, e2);
        }
        return categoryDelta;
    }

    public boolean isSorterProperty(Object element, String property) {
        TreePath[] parentPaths;
        NavigatorContentServiceContentProvider cp = (NavigatorContentServiceContentProvider)this.contentService.createCommonContentProvider();
        TreePath[] treePathArray = parentPaths = cp.getParents(element);
        int n = parentPaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath parentPath = treePathArray[n2];
            if (this.isSorterProperty(parentPath, element, property)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSorterProperty(TreePath parentPath, Object element, String property) {
        INavigatorContentDescriptor contentDesc = this.getSource(element);
        if (parentPath.getSegmentCount() == 0) {
            return false;
        }
        ViewerSorter sorter = this.sorterService.findSorter(contentDesc, parentPath.getLastSegment(), element, null);
        if (sorter != null) {
            return sorter.isSorterProperty(element, property);
        }
        return false;
    }

    private INavigatorContentDescriptor getSource(Object o) {
        NavigatorContentDescriptor ncd = ((NavigatorContentService)this.contentService).getSourceOfContribution(o);
        if (ncd != null) {
            return ncd;
        }
        Set descriptors = ((NavigatorContentService)this.contentService).findDescriptorsByTriggerPoint(o, true);
        if (descriptors != null && descriptors.size() > 0) {
            ncd = (INavigatorContentDescriptor)descriptors.iterator().next();
            return ncd;
        }
        return null;
    }
}

