/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.graph;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;

public class TopObjectIterator {
    public static <T extends Punkt_Objekt> Stream<T> getEdgeObjects(TOP_Kante edge, boolean followTopDirection, Class<T> classType) {
        Comparator<Punkt_Objekt> comp = Comparator.comparing(po -> ((Punkt_Objekt_TOP_Kante_AttributeGroup)po.getPunktObjektTOPKante().get(0)).getAbstand().getWert());
        if (!followTopDirection) {
            comp = comp.reversed();
        }
        return StreamSupport.stream(BasisAttributExtensions.getContainer((EObject)edge).get(classType).spliterator(), false).filter(c -> ((Punkt_Objekt_TOP_Kante_AttributeGroup)c.getPunktObjektTOPKante().get(0)).getIDTOPKante().getValue().equals(edge)).sorted(comp);
    }

    public static <T extends Punkt_Objekt> Stream<T> getEdgeObjectsFromPoint(TOP_Kante edge, boolean followTopDirection, BigDecimal startAt, Class<T> classType) {
        int startAtDirection;
        Comparator<Punkt_Objekt> comp = Comparator.comparing(po -> ((Punkt_Objekt_TOP_Kante_AttributeGroup)po.getPunktObjektTOPKante().get(0)).getAbstand().getWert());
        int n = startAtDirection = followTopDirection ? 1 : -1;
        if (!followTopDirection) {
            comp = comp.reversed();
        }
        return StreamSupport.stream(BasisAttributExtensions.getContainer((EObject)edge).get(classType).spliterator(), false).filter(c -> ((Punkt_Objekt_TOP_Kante_AttributeGroup)c.getPunktObjektTOPKante().get(0)).getIDTOPKante().getValue().equals(edge)).filter(c -> {
            int value = ((Punkt_Objekt_TOP_Kante_AttributeGroup)c.getPunktObjektTOPKante().get(0)).getAbstand().getWert().compareTo(startAt);
            return value == 0 || value == startAtDirection;
        }).sorted(comp);
    }

    public static <T extends Punkt_Objekt> Stream<T> getPathObjects(TopPath path, Class<T> classType) {
        if (path.edges().isEmpty()) {
            return Stream.of(new Punkt_Objekt[0]);
        }
        ArrayList<Stream<T>> its = new ArrayList<Stream<T>>();
        TOP_Kante previousEdge = null;
        for (TOP_Kante edge : path.edges()) {
            boolean followTopDirection = previousEdge == null || previousEdge.getIDTOPKnotenB() == edge.getIDTOPKnotenA();
            its.add(TopObjectIterator.getEdgeObjects(edge, followTopDirection, classType));
            previousEdge = edge;
        }
        return its.stream().flatMap(s -> s);
    }

    public static <T extends Punkt_Objekt> Stream<T> getPathObjectsBetween(TopPath path, Class<T> classType, BigDecimal startLimit, BigDecimal endLimit) {
        if (path.edges().isEmpty()) {
            return Stream.of(new Punkt_Objekt[0]);
        }
        TOP_Kante firstEdge = (TOP_Kante)path.edges().get(0);
        TOP_Kante lastEdge = (TOP_Kante)path.edges().get(path.edges().size() - 1);
        return TopObjectIterator.getPathObjects(path, classType).filter(c -> {
            Punkt_Objekt_TOP_Kante_AttributeGroup potk = (Punkt_Objekt_TOP_Kante_AttributeGroup)c.getPunktObjektTOPKante().get(0);
            TOP_Kante tk = potk.getIDTOPKante().getValue();
            if (tk == firstEdge && potk.getAbstand().getWert().compareTo(startLimit) < 0) {
                return false;
            }
            return tk != lastEdge || potk.getAbstand().getWert().compareTo(endLimit) <= 0;
        });
    }
}

