/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.enumtranslation;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.exceptions.NoEnumTranslationFound;
import org.eclipse.set.core.Messages;
import org.eclipse.set.core.enumtranslation.Enumerators;
import org.eclipse.set.core.services.enumtranslation.EnumTranslation;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.utils.enums.EnumTranslationUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class EnumTranslationServiceImpl
implements EnumTranslationService {
    Logger logger = LoggerFactory.getLogger(EnumTranslationServiceImpl.class);
    @Reference
    Enumerators enumerators;
    @Reference
    Messages messages;

    protected static Field[] getDeclaredFields() {
        return Enumerators.class.getDeclaredFields();
    }

    public EnumTranslation translate(boolean value) throws NoEnumTranslationFound {
        return this.translate(EnumTranslationUtils.getKeyBasis((Boolean)value));
    }

    public EnumTranslation translate(Enumerator obj) {
        Enumerator enumerator = obj;
        String enumeratorName = EnumTranslationUtils.getKeyBasis((Enumerator)enumerator);
        return this.translate(enumeratorName);
    }

    public EnumTranslation translate(BasisAttribut_AttributeGroup owner, Enumerator enumerator) {
        EnumTranslation translate = this.translate(enumerator);
        if (!translate.getAlternative().equals("sonstige")) {
            return translate;
        }
        final String notes = owner.getIDBearbeitungsvermerk().stream().map(note -> Optional.ofNullable(note.getValue().getBearbeitungsvermerkAllg().getKurztext().getWert())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(",\r\n"));
        if (notes.isBlank() || notes.isEmpty()) {
            return translate;
        }
        return new EnumTranslation(){

            public String getSorting() {
                return notes;
            }

            public String getPresentation() {
                return notes;
            }

            public String getKeyBasis() {
                return "sonstige";
            }

            public String getAlternative() {
                return notes;
            }
        };
    }

    public <C extends Enumerator> List<EnumTranslation> translate(List<C> enums) {
        return enums.stream().map(this::translate).toList();
    }

    public EnumTranslation translate(Translateable translateable) {
        return this.translate(translateable.getKey());
    }

    private EnumTranslation translate(final String keyBasis) {
        return new EnumTranslation(){

            public String getAlternative() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeyAlternative((String)keyBasis));
            }

            public String getKeyBasis() {
                return keyBasis;
            }

            public String getPresentation() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeyPresentation((String)keyBasis));
            }

            public String getSorting() {
                return EnumTranslationServiceImpl.this.translateSingle(EnumTranslationUtils.getKeySorting((String)keyBasis));
            }
        };
    }

    private String translateApplicationEnum(String key) {
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = Messages.class.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(key)) {
                    return ((String)field.get(this.messages)).trim();
                }
                ++n2;
            }
            this.logger.error("Missing translation for ENUM {}", (Object)key);
            return key;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    String translateSingle(String key) {
        try {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = EnumTranslationServiceImpl.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                String fieldName = field.getName();
                if (fieldName.equals(key)) {
                    return ((String)field.get(this.enumerators)).trim();
                }
                ++n2;
            }
            return this.translateApplicationEnum(key);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }
}

