/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.feature.siteplan.TrackSwitchMetadata;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.model.planpro.BasisTypen.ENUMLinksRechts;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Abstand_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Geodaten.TOP_Laenge_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_TOP_Kante_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.ENUMWKrArt;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Kreuzungsgleis_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Anlage_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Art_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.WKrAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;

public class TrackSwitchLeg {
    private final int TRACK_SWITCH_POINTS = 10;
    private final BigDecimal DEFAULT_TRACKSWITCH_LEG_LENGTH;
    private TOP_Kante topKante;
    private TOP_Knoten topKnoten;
    private ENUMTOPAnschluss connection;
    private BigDecimal length = this.DEFAULT_TRACKSWITCH_LEG_LENGTH = BigDecimal.valueOf(20L);
    private BigDecimal start = BigDecimal.ZERO;

    public BigDecimal getLength() {
        return this.length;
    }

    public TOP_Kante getTOPKante() {
        return this.topKante;
    }

    public ENUMTOPAnschluss getConnection() {
        return this.connection;
    }

    public Coordinate[] getCoordinates(GeoKanteGeometryService geometryService, PositionService positionService) {
        BigDecimal legLength = this.start.add(this.length).min(this.topKante.getTOPKanteAllg().getTOPLaenge().getWert());
        BigDecimal offset = BigDecimal.valueOf(1.0E-4);
        BigDecimal _divide = legLength.subtract(this.start).divide(BigDecimal.valueOf(10 - 1), 5, RoundingMode.HALF_DOWN);
        BigDecimal sectionLength = _divide.subtract(offset);
        ArrayList result = CollectionLiterals.newArrayList();
        int i = 0;
        while (i < 10) {
            BigDecimal _valueOf = BigDecimal.valueOf(i);
            BigDecimal _multiply = sectionLength.multiply(_valueOf);
            BigDecimal _plus = this.start.add(_multiply);
            result.add(geometryService.getCoordinate(this.topKante, this.topKnoten, _plus, BigDecimal.ZERO, null));
            ++i;
        }
        Functions.Function1 _function = coordinate -> positionService.transformPosition((GEOKanteCoordinate)coordinate);
        return (Coordinate[])Conversions.unwrapArray((Object)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)result), (Functions.Function1)_function), Coordinate.class);
    }

    public Position getNodeCoordinate(GeoKanteGeometryService geometryService, PositionService positionService) {
        return positionService.transformPosition(geometryService.getCoordinate(this.topKante, this.topKnoten, BigDecimal.ZERO, BigDecimal.ZERO, null));
    }

    public Position getCoordinate(BigDecimal distance, BigDecimal lateralDistance, GeoKanteGeometryService geometryService, PositionService positionService) {
        BigDecimal _plus = this.start.add(distance);
        return positionService.transformPosition(geometryService.getCoordinate(this.topKante, this.topKnoten, _plus, lateralDistance, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN));
    }

    public static TrackSwitchLeg getLeg(List<W_Kr_Gsp_Komponente> components, TrackSwitchMetadata metadata, int legIndex) {
        boolean _equals;
        TrackSwitchLeg leg = new TrackSwitchLeg();
        int _length = ((Object[])Conversions.unwrapArray(components, Object.class)).length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            W_Kr_Gsp_Komponente component = (W_Kr_Gsp_Komponente)org.eclipse.xtext.xbase.lib.IterableExtensions.head(components);
            leg.topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component);
            if (!(leg.topKnoten != null && ((Object[])Conversions.unwrapArray(TrackSwitchLeg.getTrackSwitchLegs(leg.topKnoten), Object.class)).length - 1 >= legIndex || TrackSwitchLeg.isCrossType(component))) {
                return null;
            }
            leg.determineLegLength(component, metadata, legIndex);
        } else {
            W_Kr_Gsp_Komponente component_1 = components.get(legIndex);
            leg.topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component_1);
            leg.determineLegLength(component_1, metadata, legIndex);
        }
        if (leg.topKante == null || leg.topKnoten == null) {
            return null;
        }
        return leg;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BigDecimal determineLegLength(W_Kr_Gsp_Komponente component, TrackSwitchMetadata metadata, int legIndex) {
        BigDecimal _xblockexpression = null;
        W_Kr_Anlage trackSwitch = WKrGspElementExtensions.getWKrAnlage((W_Kr_Gsp_Element)WKrGspKomponenteExtensions.getWKrGspElement((W_Kr_Gsp_Komponente)component));
        ENUMWKrArt switchType = trackSwitch.getWKrAnlageAllg().getWKrArt().getWert();
        if (switchType != null) {
            switch (switchType) {
                case ENUMW_KR_ART_FLACHKREUZUNG: 
                case ENUMW_KR_ART_KR: {
                    this.determineCrossSwitchLegLength(component, metadata, legIndex);
                    break;
                }
                case ENUMW_KR_ART_DKW: {
                    BigDecimal _divide;
                    this.topKante = TrackSwitchLeg.getCrossingLeg(component);
                    if (metadata != null) {
                        BigDecimal _minus;
                        this.length = BigDecimal.valueOf(metadata.rightCrossing.crossing.mainLeg);
                        if (metadata.rightCrossing.crossingTriangle == null) break;
                        BigDecimal _valueOf = BigDecimal.valueOf(metadata.rightCrossing.crossingTriangle.mainLeg);
                        this.start = _minus = _valueOf.subtract(this.length);
                        break;
                    }
                    TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
                    if (this.topKante != null) {
                        _tOPKanteAllg = this.topKante.getTOPKanteAllg();
                    }
                    TOP_Laenge_TypeClass _tOPLaenge = null;
                    if (_tOPKanteAllg != null) {
                        _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
                    }
                    BigDecimal _wert = _tOPLaenge.getWert();
                    BigDecimal _valueOf_1 = BigDecimal.valueOf(2L);
                    this.length = _divide = _wert.divide(_valueOf_1, MathContext.DECIMAL128);
                    break;
                }
                case ENUMW_KR_ART_EKW: {
                    W_Kr_Gsp_Komponente anotherGspComponent;
                    if (legIndex == 0) {
                        this.topKante = TrackSwitchLeg.getCrossingLeg(component);
                        this.start = this.length = this.getEKWLegLength(component, metadata);
                        break;
                    }
                    W_Kr_Gsp_Element currentGspElement = WKrGspKomponenteExtensions.getWKrGspElement((W_Kr_Gsp_Komponente)component);
                    W_Kr_Anlage gspAnlage = WKrGspElementExtensions.getWKrAnlage((W_Kr_Gsp_Element)currentGspElement);
                    Functions.Function1 _function = it -> it != currentGspElement;
                    W_Kr_Gsp_Element anotherGspElement = (W_Kr_Gsp_Element)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)WKrAnlageExtensions.getWKrGspElemente((W_Kr_Anlage)gspAnlage), (Functions.Function1)_function);
                    List _wKrGspKomponenten = null;
                    if (anotherGspElement != null) {
                        _wKrGspKomponenten = WKrGspElementExtensions.getWKrGspKomponenten((W_Kr_Gsp_Element)anotherGspElement);
                    }
                    if ((anotherGspComponent = (W_Kr_Gsp_Komponente)IterableExtensions.getFirstOrNull(_wKrGspKomponenten)) == null) {
                        String _wert_1 = gspAnlage.getIdentitaet().getWert();
                        throw new IllegalArgumentException(_wert_1);
                    }
                    this.topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)anotherGspComponent);
                    this.length = this.getEKWLegLength(anotherGspComponent, metadata);
                    this.topKante = TrackSwitchLeg.getCrossingLeg(anotherGspComponent);
                    break;
                }
                default: {
                    this.topKante = ((TOP_Kante[])Conversions.unwrapArray(TrackSwitchLeg.getTrackSwitchLegs(this.topKnoten), TOP_Kante.class))[legIndex];
                    this.connection = TopKanteExtensions.getTOPAnschluss((TOP_Kante)this.topKante, (TOP_Knoten)this.topKnoten);
                    if (metadata.trackSwitchLength == null) break;
                    if (legIndex == 0) {
                        this.length = BigDecimal.valueOf(metadata.trackSwitchLength.mainLeg);
                        break;
                    }
                    this.length = BigDecimal.valueOf(metadata.trackSwitchLength.sideLeg);
                    break;
                }
            }
        } else {
            this.topKante = ((TOP_Kante[])Conversions.unwrapArray(TrackSwitchLeg.getTrackSwitchLegs(this.topKnoten), TOP_Kante.class))[legIndex];
            this.connection = TopKanteExtensions.getTOPAnschluss((TOP_Kante)this.topKante, (TOP_Knoten)this.topKnoten);
            if (metadata.trackSwitchLength != null) {
                this.length = legIndex == 0 ? BigDecimal.valueOf(metadata.trackSwitchLength.mainLeg) : BigDecimal.valueOf(metadata.trackSwitchLength.sideLeg);
            }
        }
        BigDecimal _xifexpression = null;
        if (this.length != null) {
            if (this.length != BigDecimal.ZERO) return _xifexpression;
        }
        _xifexpression = this.length = this.DEFAULT_TRACKSWITCH_LEG_LENGTH;
        return _xifexpression;
    }

    private static boolean isCrossType(W_Kr_Gsp_Komponente component) {
        ENUMWKrArt type;
        W_Kr_Gsp_Element _wKrGspElement = null;
        if (component != null) {
            _wKrGspElement = WKrGspKomponenteExtensions.getWKrGspElement((W_Kr_Gsp_Komponente)component);
        }
        W_Kr_Anlage _wKrAnlage = null;
        if (_wKrGspElement != null) {
            _wKrAnlage = WKrGspElementExtensions.getWKrAnlage((W_Kr_Gsp_Element)_wKrGspElement);
        }
        W_Kr_Anlage anlage = _wKrAnlage;
        W_Kr_Anlage_Allg_AttributeGroup _wKrAnlageAllg = null;
        if (anlage != null) {
            _wKrAnlageAllg = anlage.getWKrAnlageAllg();
        }
        W_Kr_Art_TypeClass _wKrArt = null;
        if (_wKrAnlageAllg != null) {
            _wKrArt = _wKrAnlageAllg.getWKrArt();
        }
        ENUMWKrArt _wert = null;
        if (_wKrArt != null) {
            _wert = _wKrArt.getWert();
        }
        return (type = _wert) == ENUMWKrArt.ENUMW_KR_ART_KR || type == ENUMWKrArt.ENUMW_KR_ART_FLACHKREUZUNG;
    }

    private BigDecimal determineCrossSwitchLegLength(W_Kr_Gsp_Komponente component, TrackSwitchMetadata metadata, int index) {
        boolean _tripleEquals;
        BigDecimal _xblockexpression = null;
        Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint = (Punkt_Objekt_TOP_Kante_AttributeGroup)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)component).get(index);
        ENUMWirkrichtung _wert = singlePoint.getWirkrichtung().getWert();
        boolean bl = _tripleEquals = _wert == ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN;
        if (_tripleEquals) {
            BigDecimal _minus;
            this.topKnoten = TopKanteExtensions.getTOPKnotenB((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint));
            BigDecimal _laenge = TopKanteExtensions.getLaenge((TOP_Kante)PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint));
            BigDecimal _wert_1 = singlePoint.getAbstand().getWert();
            this.start = _minus = _laenge.subtract(_wert_1);
        } else {
            Abstand_TypeClass _abstand = null;
            if (singlePoint != null) {
                _abstand = singlePoint.getAbstand();
            }
            BigDecimal _wert_2 = null;
            if (_abstand != null) {
                _wert_2 = _abstand.getWert();
            }
            this.start = _wert_2;
            TOP_Kante _topKante = null;
            if (singlePoint != null) {
                _topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)singlePoint);
            }
            this.topKnoten = TopKanteExtensions.getTOPKnotenA((TOP_Kante)_topKante);
        }
        ID_TOP_Kante_TypeClass _iDTOPKante = null;
        if (singlePoint != null) {
            _iDTOPKante = singlePoint.getIDTOPKante();
        }
        TOP_Kante _value = null;
        if (_iDTOPKante != null) {
            _value = _iDTOPKante.getValue();
        }
        this.topKante = _value;
        BigDecimal _xifexpression = null;
        if (metadata != null) {
            BigDecimal _xblockexpression_1 = null;
            TrackSwitchMetadata.CrossingSide _xifexpression_1 = null;
            ENUMWirkrichtung _wert_3 = singlePoint.getWirkrichtung().getWert();
            boolean _equals = Objects.equals(_wert_3, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_GEGEN);
            _xifexpression_1 = _equals ? metadata.rightCrossing : metadata.leftCrossing;
            TrackSwitchMetadata.CrossingSide crossingSide = _xifexpression_1;
            BigDecimal _xifexpression_2 = null;
            if (crossingSide != null) {
                _xifexpression_2 = this.length = BigDecimal.valueOf(crossingSide.crossing.mainLeg);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private BigDecimal getEKWLegLength(W_Kr_Gsp_Komponente component, TrackSwitchMetadata metadata) {
        if (metadata != null) {
            return BigDecimal.valueOf(metadata.rightCrossing.crossing.mainLeg);
        }
        TOP_Kante crossingLeg = TrackSwitchLeg.getCrossingLeg(component);
        Functions.Function1 _function = it -> it != crossingLeg;
        TOP_Kante straightEdge = (TOP_Kante)org.eclipse.xtext.xbase.lib.IterableExtensions.findFirst((Iterable)PunktObjektExtensions.getTopKanten((Punkt_Objekt)component), (Functions.Function1)_function);
        BigDecimal _elvis = null;
        TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
        if (straightEdge != null) {
            _tOPKanteAllg = straightEdge.getTOPKanteAllg();
        }
        TOP_Laenge_TypeClass _tOPLaenge = null;
        if (_tOPKanteAllg != null) {
            _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
        }
        BigDecimal _wert = null;
        if (_tOPLaenge != null) {
            _wert = _tOPLaenge.getWert();
        }
        _elvis = _wert != null ? _wert : BigDecimal.ZERO;
        return _elvis.divide(BigDecimal.TWO, 5, RoundingMode.DOWN);
    }

    protected static TOP_Kante getCrossingLeg(W_Kr_Gsp_Komponente component) {
        ENUMLinksRechts crossingSide;
        boolean _equals;
        TOP_Knoten topKnoten = PunktObjektExtensions.getTopKnoten((Punkt_Objekt)component);
        Zungenpaar_AttributeGroup _zungenpaar = null;
        if (component != null) {
            _zungenpaar = component.getZungenpaar();
        }
        Kreuzungsgleis_TypeClass _kreuzungsgleis = null;
        if (_zungenpaar != null) {
            _kreuzungsgleis = _zungenpaar.getKreuzungsgleis();
        }
        ENUMLinksRechts _wert = null;
        if (_kreuzungsgleis != null) {
            _wert = _kreuzungsgleis.getWert();
        }
        if (_equals = Objects.equals(crossingSide = _wert, ENUMLinksRechts.ENUM_LINKS_RECHTS_RECHTS)) {
            Functions.Function1 _function = it -> {
                ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                return Objects.equals(_tOPAnschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
            };
            return (TOP_Kante)org.eclipse.xtext.xbase.lib.IterableExtensions.head((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten), (Functions.Function1)_function));
        }
        boolean _equals_1 = Objects.equals(crossingSide, ENUMLinksRechts.ENUM_LINKS_RECHTS_LINKS);
        if (_equals_1) {
            Functions.Function1 _function_1 = it -> {
                ENUMTOPAnschluss _tOPAnschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)topKnoten);
                return Objects.equals(_tOPAnschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS);
            };
            return (TOP_Kante)org.eclipse.xtext.xbase.lib.IterableExtensions.head((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)topKnoten), (Functions.Function1)_function_1));
        }
        return null;
    }

    private static Iterable<TOP_Kante> getTrackSwitchLegs(TOP_Knoten trackSwitchTopNode) {
        Functions.Function1 _function = it -> {
            boolean _xblockexpression = false;
            ENUMTOPAnschluss anschluss = TopKanteExtensions.getTOPAnschluss((TOP_Kante)it, (TOP_Knoten)trackSwitchTopNode);
            _xblockexpression = Objects.equals(anschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS) || Objects.equals(anschluss, ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
            return _xblockexpression;
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)TopKnotenExtensions.getTopKanten((TOP_Knoten)trackSwitchTopNode), (Functions.Function1)_function);
    }
}

