/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public final class SubCommand {
    private volatile ArgumentParser globalArgumentParser;
    private final ArgumentParser subcommandArgumentParser;
    private volatile boolean isPresent;
    private final LinkedHashMap<String[], String> exampleUsages;
    private final Map<String, String> names;
    private final String description;

    public SubCommand(String name, String description, ArgumentParser parser, LinkedHashMap<String[], String> exampleUsages) throws ArgumentException {
        this.names = new LinkedHashMap<String, String>(5);
        this.addName(name);
        this.description = description;
        if (description == null || description.length() == 0) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_DESCRIPTION_NULL_OR_EMPTY.get());
        }
        this.subcommandArgumentParser = parser;
        if (parser == null) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_NULL.get());
        }
        if (parser.allowsTrailingArguments()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_ALLOWS_TRAILING_ARGS.get());
        }
        if (parser.hasSubCommands()) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_PARSER_HAS_SUBCOMMANDS.get());
        }
        this.exampleUsages = exampleUsages == null ? new LinkedHashMap() : new LinkedHashMap<String[], String>(exampleUsages);
        this.isPresent = false;
        this.globalArgumentParser = null;
    }

    private SubCommand(SubCommand source) {
        this.names = new LinkedHashMap<String, String>(source.names);
        this.description = source.description;
        this.subcommandArgumentParser = new ArgumentParser(source.subcommandArgumentParser, this);
        this.exampleUsages = new LinkedHashMap<String[], String>(source.exampleUsages);
        this.isPresent = false;
        this.globalArgumentParser = null;
    }

    public String getPrimaryName() {
        return this.names.values().iterator().next();
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.names.values()));
    }

    public boolean hasName(String name) {
        return this.names.containsKey(StaticUtils.toLowerCase(name));
    }

    public void addName(String name) throws ArgumentException {
        if (name == null || name.length() == 0) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_NULL_OR_EMPTY.get());
        }
        String lowerName = StaticUtils.toLowerCase(name);
        if (this.names.containsKey(lowerName)) {
            throw new ArgumentException(ArgsMessages.ERR_SUBCOMMAND_NAME_ALREADY_IN_USE.get(name));
        }
        if (this.globalArgumentParser != null) {
            this.globalArgumentParser.addSubCommand(name, this);
        }
        this.names.put(lowerName, name);
    }

    public String getDescription() {
        return this.description;
    }

    public ArgumentParser getArgumentParser() {
        return this.subcommandArgumentParser;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    void setPresent() {
        this.isPresent = true;
    }

    ArgumentParser getGlobalArgumentParser() {
        return this.globalArgumentParser;
    }

    void setGlobalArgumentParser(ArgumentParser globalArgumentParser) {
        this.globalArgumentParser = globalArgumentParser;
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        return this.exampleUsages;
    }

    public SubCommand getCleanCopy() {
        return new SubCommand(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SubCommand(");
        if (this.names.size() == 1) {
            buffer.append("name='");
            buffer.append(this.names.values().iterator().next());
            buffer.append('\'');
        } else {
            buffer.append("names={");
            Iterator<String> iterator = this.names.values().iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(", description='");
        buffer.append(this.description);
        buffer.append("', parser=");
        this.subcommandArgumentParser.toString(buffer);
        buffer.append(')');
    }
}

